/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.definition.FluidTexture;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class MIFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"modern_industrialization");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"modern_industrialization");
    public static final SortedMap<ResourceLocation, FluidDefinition> FLUID_DEFINITIONS = new TreeMap<ResourceLocation, FluidDefinition>();
    public static final FluidDefinition ACETYLENE = MIFluids.fluid("Acetylene", "acetylene", -10472443, true);
    public static final FluidDefinition ACRYLIC_ACID = MIFluids.fluid("Acrylic Acid", "acrylic_acid", -14950731, 230);
    public static final FluidDefinition ACRYLIC_GLUE = MIFluids.fluid("Acrylic Glue", "acrylic_glue", -14950828, 255);
    public static final FluidDefinition ARGON = MIFluids.fluid("Argon", "argon", -1885785, true);
    public static final FluidDefinition BENZENE = MIFluids.fluid("Benzene", "benzene", -994951, 240);
    public static final FluidDefinition BIODIESEL = MIFluids.fluid("Biodiesel", "biodiesel", -10702816, 240);
    public static final FluidDefinition BOOSTED_DIESEL = MIFluids.fluid("Boosted Diesel", "boosted_diesel", -156918, 240);
    public static final FluidDefinition BUTADIENE = MIFluids.fluid("Butadiene", "butadiene", -3097318, 240);
    public static final FluidDefinition CAPROLACTAM = MIFluids.fluid("Caprolactam", "caprolactam", -8825776, 240);
    public static final FluidDefinition CHLORINE = MIFluids.fluid("Chlorine", "chlorine", -4734700, true);
    public static final FluidDefinition CHROMIUM_HYDROCHLORIC_SOLUTION = MIFluids.fluid("Chromium Hydrochloric Solution", "chromium_hydrochloric_solution", -344461, 230);
    public static final FluidDefinition CREOSOTE = MIFluids.fluid("Creosote", "creosote", -10264496, 240);
    public static final FluidDefinition CRUDE_OIL = MIFluids.fluid("Crude Oil", "crude_oil", -12699592, 240);
    public static final FluidDefinition CRYOFLUID = MIFluids.fluid("Cryofluid", "cryofluid", -12795672, 230);
    public static final FluidDefinition DEUTERIUM = MIFluids.fluid("Deuterium", "deuterium", -7070772, true);
    public static final FluidDefinition DIESEL = MIFluids.fluid("Diesel", "diesel", -1458387, 240);
    public static final FluidDefinition DIETHYL_ETHER = MIFluids.fluid("Diethyl Ether", "diethyl_ether", -7419849, 240);
    public static final FluidDefinition ETHANOL = MIFluids.fluid("Ethanol", "ethanol", -10450634, 240);
    public static final FluidDefinition ETHYLBENZENE = MIFluids.fluid("Ethylbenzene", "ethylbenzene", -3868073, 240);
    public static final FluidDefinition ETHYLENE = MIFluids.fluid("Ethylene", "ethylene", -14125455, true);
    public static final FluidDefinition HEAVY_FUEL = MIFluids.fluid("Heavy Fuel", "heavy_fuel", -9402, 240);
    public static final FluidDefinition HEAVY_WATER = MIFluids.fluid("Heavy Water", "heavy_water", -9561872);
    public static final FluidDefinition HEAVY_WATER_STEAM = MIFluids.fluid("Heavy Water Steam", "heavy_water_steam", -2502680, 230, FluidTexture.STEAM_LIKE, true);
    public static final FluidDefinition HELIUM = MIFluids.fluid("Helium", "helium", -1645435, true);
    public static final FluidDefinition HELIUM_PLASMA = MIFluids.fluid("Helium Plasma", "helium_plasma", -1954, 255, FluidTexture.PLASMA_LIKE, true);
    public static final FluidDefinition HELIUM_3 = MIFluids.fluid("Helium 3", "helium_3", -8135086, true);
    public static final FluidDefinition HIGH_PRESSURE_HEAVY_WATER = MIFluids.fluid("High Pressure Heavy Water", "high_pressure_heavy_water", -12776566, 230);
    public static final FluidDefinition HIGH_PRESSURE_HEAVY_WATER_STEAM = MIFluids.fluid("High Pressure Heavy Water Steam", "high_pressure_heavy_water_steam", -9608070, 240, FluidTexture.STEAM_LIKE, true);
    public static final FluidDefinition HIGH_PRESSURE_STEAM = MIFluids.fluid("High Pressure Steam", "high_pressure_steam", -6513508, 240, FluidTexture.STEAM_LIKE, true);
    public static final FluidDefinition HIGH_PRESSURE_WATER = MIFluids.fluid("High Pressure Water", "high_pressure_water", -15446856, 230);
    public static final FluidDefinition HYDROCHLORIC_ACID = MIFluids.fluid("Hydrochloric Acid", "hydrochloric_acid", -6374138);
    public static final FluidDefinition HYDROGEN = MIFluids.fluid("Hydrogen", "hydrogen", -14988596, true);
    public static final FluidDefinition LIGHT_FUEL = MIFluids.fluid("Light Fuel", "light_fuel", -5818, 240);
    public static final FluidDefinition LIQUID_AIR = MIFluids.fluid("Liquid Air", "liquid_air", -8992775, 230);
    public static final FluidDefinition LUBRICANT = MIFluids.fluid("Lubricant", "lubricant", -15360, 255);
    public static final FluidDefinition MANGANESE_SULFURIC_SOLUTION = MIFluids.fluid("Manganese Sulfuric Solution", "manganese_sulfuric_solution", -4625345, 230);
    public static final FluidDefinition METHANE = MIFluids.fluid("Methane", "methane", -4767527, true);
    public static final FluidDefinition MOLTEN_REDSTONE = MIFluids.fluid("Molten Redstone", "molten_redstone", -5501948, 255);
    public static final FluidDefinition NAPHTHA = MIFluids.fluid("Naphtha", "naphtha", -5922210, 240);
    public static final FluidDefinition NITROGEN = MIFluids.fluid("Nitrogen", "nitrogen", -12283482, true);
    public static final FluidDefinition NYLON = MIFluids.fluid("Nylon", "nylon", -6788508, 255);
    public static final FluidDefinition OXYGEN = MIFluids.fluid("Oxygen", "oxygen", -13461774, true);
    public static final FluidDefinition PLANT_OIL = MIFluids.fluid("Plant Oil", "plant_oil", -8864482, 240);
    public static final FluidDefinition PLATINUM_SULFURIC_SOLUTION = MIFluids.fluid("Platinum Sulfuric Solution", "platinum_sulfuric_solution", -1663371, 230);
    public static final FluidDefinition POLYETHYLENE = MIFluids.fluid("Polyethylene", "polyethylene", -10249064, 240);
    public static final FluidDefinition POLYVINYL_CHLORIDE = MIFluids.fluid("Polyvinyl Chloride", "polyvinyl_chloride", -601108, true);
    public static final FluidDefinition PROPENE = MIFluids.fluid("Propene", "propene", -6790068, 240);
    public static final FluidDefinition PURIFIED_PLATINUM_SULFURIC_SOLUTION = MIFluids.fluid("Purified Platinum Sulfuric Solution", "purified_platinum_sulfuric_solution", -1195894, 230);
    public static final FluidDefinition RAW_BIODIESEL = MIFluids.fluid("Raw Biodiesel", "raw_biodiesel", -13860855, 255);
    public static final FluidDefinition RAW_SYNTHETIC_OIL = MIFluids.fluid("Raw Synthetic Oil", "raw_synthetic_oil", -12105920, 240);
    public static final FluidDefinition SHALE_OIL = MIFluids.fluid("Shale Oil", "shale_oil", -9538701, 240);
    public static final FluidDefinition SODIUM_HYDROXIDE = MIFluids.fluid("Sodium Hydroxide", "sodium_hydroxide", -11505207);
    public static final FluidDefinition SOLDERING_ALLOY = MIFluids.fluid("Soldering Alloy", "soldering_alloy", -5520193, 255, FluidTexture.LAVA_LIKE, false);
    public static final FluidDefinition SUGAR_SOLUTION = MIFluids.fluid("Sugar Solution", "sugar_solution", -7353125, 230);
    public static final FluidDefinition STEAM = MIFluids.fluid("Steam", "steam", -1118482, 230, FluidTexture.STEAM_LIKE, true);
    public static final FluidDefinition STEAM_CRACKED_HEAVY_FUEL = MIFluids.fluid("Steam-Cracked Heavy Fuel", "steam_cracked_heavy_fuel", -6787, 240);
    public static final FluidDefinition STEAM_CRACKED_LIGHT_FUEL = MIFluids.fluid("Steam-Cracked Light Fuel", "steam_cracked_light_fuel", -4956, 240);
    public static final FluidDefinition STEAM_CRACKED_NAPHTHA = MIFluids.fluid("Steam-Cracked Naphtha", "steam_cracked_naphtha", -2961234, 240);
    public static final FluidDefinition STYRENE = MIFluids.fluid("Styrene", "styrene", -6404110, 240);
    public static final FluidDefinition STYRENE_BUTADIENE = MIFluids.fluid("Styrene-Butadiene", "styrene_butadiene", -6520768, 240);
    public static final FluidDefinition STYRENE_BUTADIENE_RUBBER = MIFluids.fluid("Styrene-Butadiene Rubber", "styrene_butadiene_rubber", -12437471, 255);
    public static final FluidDefinition SULFURIC_ACID = MIFluids.fluid("Sulfuric Acid", "sulfuric_acid", -2008320);
    public static final FluidDefinition SULFURIC_CRUDE_OIL = MIFluids.fluid("Sulfuric Crude Oil", "sulfuric_crude_oil", -11841199, 240);
    public static final FluidDefinition SULFURIC_HEAVY_FUEL = MIFluids.fluid("Sulfuric Heavy Fuel", "sulfuric_heavy_fuel", -864452, 240);
    public static final FluidDefinition SULFURIC_LIGHT_FUEL = MIFluids.fluid("Sulfuric Light Fuel", "sulfuric_light_fuel", -729804, 240);
    public static final FluidDefinition SULFURIC_NAPHTHA = MIFluids.fluid("Sulfuric Naphtha", "sulfuric_naphtha", -5925026, 240);
    public static final FluidDefinition SYNTHETIC_OIL = MIFluids.fluid("Synthetic Oil", "synthetic_oil", -15066598, 240);
    public static final FluidDefinition SYNTHETIC_RUBBER = MIFluids.fluid("Synthetic Rubber", "synthetic_rubber", -15066598, 255);
    public static final FluidDefinition TOLUENE = MIFluids.fluid("Toluene", "toluene", -6494483, 240);
    public static final FluidDefinition TRITIUM = MIFluids.fluid("Tritium", "tritium", -3400880, true);
    public static final FluidDefinition UU_MATTER = MIFluids.fluid("UU Matter", "uu_matter", -65345, 255, false);
    public static final FluidDefinition VINYL_CHLORIDE = MIFluids.fluid("Vinyl Chloride", "vinyl_chloride", -1202215, 230);

    public static void init(IEventBus modBus) {
        FLUIDS.register(modBus);
        FLUID_TYPES.register(modBus);
    }

    public static FluidDefinition fluid(String englishName, String id, int color, int opacity, FluidTexture texture, boolean isGas) {
        FluidDefinition definition = new FluidDefinition(englishName, id, color, opacity, texture, isGas);
        if (FLUID_DEFINITIONS.put(definition.getId(), definition) != null) {
            throw new IllegalArgumentException("Fluid id already taken : " + String.valueOf(definition.getId()));
        }
        return definition;
    }

    public static FluidDefinition fluid(String englishName, String id, int color, int opacity, boolean isGas) {
        return MIFluids.fluid(englishName, id, color, opacity, FluidTexture.WATER_LIKE, isGas);
    }

    public static FluidDefinition fluid(String englishName, String id, int color, int opacity) {
        return MIFluids.fluid(englishName, id, color, opacity, FluidTexture.WATER_LIKE, false);
    }

    public static FluidDefinition fluid(String englishName, String id, int color, boolean isGas) {
        return MIFluids.fluid(englishName, id, color, 180, FluidTexture.WATER_LIKE, isGas);
    }

    public static FluidDefinition fluid(String englishName, String id, int color) {
        return MIFluids.fluid(englishName, id, color, false);
    }

    static {
        KubeJSProxy.instance.fireRegisterFluidsEvent();
    }
}

