/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test.framework;

import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.test.framework.PipeBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class MdGameTestHelper
extends GameTestHelper {
    public static final String EMPTY_STRUCTURE = "empty";

    public MdGameTestHelper(GameTestInfo gameTestInfo) {
        super(gameTestInfo);
    }

    public PipeBuilder pipe(BlockPos pos, PipeBlock block) {
        this.setBlock(pos, block);
        PipeBlockEntity pipe = (PipeBlockEntity)this.getBlockEntity(pos);
        Objects.requireNonNull(pipe, "Pipe block entity is null");
        return new PipeBuilder(this, pipe);
    }

    public void checkFluid(BlockPos pos, Fluid fluid, int minAmount) {
        FluidStack drained;
        IFluidHandler handler = (IFluidHandler)this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, this.absolutePos(pos), (Object)Direction.UP);
        if (handler != null && !(drained = handler.drain(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE)).isEmpty() && drained.getAmount() >= minAmount) {
            return;
        }
        this.fail("Fluid not found", pos);
    }

    public void checkItem(BlockPos pos, Item item, int minAmount) {
        IItemHandler handler = (IItemHandler)this.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.absolutePos(pos), (Object)Direction.UP);
        if (handler != null) {
            int amountFound = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!stack.is(item)) continue;
                amountFound += stack.getCount();
            }
            if (amountFound >= minAmount) {
                return;
            }
        }
        this.fail("Item not found", pos);
    }
}

