/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.util.ItemVariant;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class TravelingItem {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    public final int id = NEXT_ID.getAndIncrement();
    public final ItemVariant variant;
    public final int amount;
    public final ItemPath path;
    public final FailedInsertStrategy strategy;
    public final double speedMultiplier;
    public double traveledDistance;
    public long lastTick;

    public TravelingItem(ItemVariant variant, int amount, ItemPath path, FailedInsertStrategy strategy, double speedMultiplier, double traveledDistance) {
        if (speedMultiplier < 0.5) {
            speedMultiplier = 0.5;
        }
        this.variant = variant;
        this.amount = amount;
        this.path = path;
        this.strategy = strategy;
        this.speedMultiplier = speedMultiplier;
        this.traveledDistance = traveledDistance;
    }

    public int getPathLength() {
        return this.path.path.length;
    }

    public double getSpeed() {
        return this.speedMultiplier * 0.02;
    }

    public CompoundTag toNbt(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("v", this.variant.toNbt(registries));
        nbt.putInt("a", this.amount);
        nbt.put("start", (Tag)SerializationHelper.posToNbt(this.path.startingPos));
        nbt.put("end", (Tag)SerializationHelper.posToNbt(this.path.targetPos));
        nbt.putString("path", SerializationHelper.encodePath(this.path.path));
        nbt.putDouble("speedMultiplier", this.speedMultiplier);
        nbt.putString("strategy", this.strategy.getSerializedName());
        nbt.putDouble("d", this.traveledDistance);
        return nbt;
    }

    public static TravelingItem fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        return new TravelingItem(ItemVariant.fromNbt(nbt.getCompound("v"), registries), nbt.getInt("a"), new ItemPath(SerializationHelper.posFromNbt(nbt.getCompound("start")), SerializationHelper.posFromNbt(nbt.getCompound("end")), SerializationHelper.decodePath(nbt.getString("path"))), FailedInsertStrategy.bySerializedName(nbt.getString("strategy")), nbt.getDouble("speedMultiplier"), nbt.getDouble("d"));
    }

    void writeClient(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        ItemVariant.STREAM_CODEC.encode((Object)buf, (Object)this.variant);
        buf.writeInt(this.amount);
        buf.writeDouble((double)(this.getPathLength() - 1));
        buf.writeDouble(this.traveledDistance);
        int currentBlock = (int)Math.floor(this.traveledDistance);
        buf.writeEnum((Enum)this.path.path[currentBlock]);
        buf.writeEnum((Enum)this.path.path[currentBlock + 1]);
        buf.writeDouble(this.getSpeed());
    }

    static ClientTravelingItem readClient(RegistryFriendlyByteBuf buf) {
        return new ClientTravelingItem(buf.readInt(), (ItemVariant)ItemVariant.STREAM_CODEC.decode((Object)buf), buf.readInt(), buf.readDouble(), buf.readDouble(), (Direction)buf.readEnum(Direction.class), (Direction)buf.readEnum(Direction.class), buf.readDouble());
    }
}

