/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.debug;

import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DebugToolItem
extends Item {
    public DebugToolItem() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity be = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (be instanceof PipeBlockEntity && ctx.getPlayer() != null) {
            if (ctx.getLevel().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            PipeBlockEntity pipe = (PipeBlockEntity)be;
            StringBuilder message = new StringBuilder();
            boolean foundNode = false;
            for (NodeHost host : pipe.getHosts()) {
                NetworkNode node = host.getManager().findNode((ServerLevel)pipe.getLevel(), pipe.getBlockPos());
                if (node == null) continue;
                ((NetworkCache)node.getNetworkCache()).appendDebugInfo(message);
                foundNode = true;
            }
            if (!foundNode) {
                message.append("No node found.\n");
            }
            ctx.getPlayer().displayClientMessage((Component)Component.literal((String)message.toString()), false);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

