/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.client.screen.CycleSettingButton;
import dev.technici4n.moderndynamics.client.screen.FluidAttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.RedstoneModeButton;
import dev.technici4n.moderndynamics.gui.menu.AttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.ConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.UpgradePanel;
import dev.technici4n.moderndynamics.gui.menu.UpgradeSlot;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AttachedIoScreen<T extends AttachedIoMenu<?>>
extends AbstractContainerScreen<T> {
    protected static final int BUTTON_GAP = 6;
    private static final int TAB_BORDER = 4;
    private static final float TAB_OPEN_PER_TICK = 0.2f;
    public static final ResourceLocation TEXTURE = MdId.of("textures/gui/attachment.png");
    public static final ResourceLocation TAB_RIGHT_TEXTURE = MdId.of("textures/gui/tab_right.png");
    private boolean redstoneTabOpen;
    private float redstoneTabCurrentOpen;
    private Rect2i redstoneTabRect = new Rect2i(0, 0, 0, 0);
    private final RedstoneModeButton redstoneModeIgnored = new RedstoneModeButton(RedstoneMode.IGNORED, ((AttachedIoMenu)this.menu)::getRedstoneMode, ((AttachedIoMenu)this.menu)::setRedstoneMode);
    private final RedstoneModeButton redstoneModeLow = new RedstoneModeButton(RedstoneMode.REQUIRES_LOW, ((AttachedIoMenu)this.menu)::getRedstoneMode, ((AttachedIoMenu)this.menu)::setRedstoneMode);
    private final RedstoneModeButton redstoneModeHigh = new RedstoneModeButton(RedstoneMode.REQUIRES_HIGH, ((AttachedIoMenu)this.menu)::getRedstoneMode, ((AttachedIoMenu)this.menu)::setRedstoneMode);
    private final List<RedstoneModeButton> redstoneButtons = List.of(this.redstoneModeIgnored, this.redstoneModeLow, this.redstoneModeHigh);

    public AttachedIoScreen(T abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        ArrayList toggleButtons = new ArrayList();
        this.addToggleButtons(toggleButtons);
        int overallWidth = toggleButtons.stream().mapToInt(AbstractWidget::getWidth).sum() + (toggleButtons.size() - 1) * 6;
        int x = this.leftPos + (this.imageWidth - overallWidth) / 2;
        for (CycleSettingButton<?> toggleButton : toggleButtons) {
            toggleButton.setX(x);
            toggleButton.setY(this.topPos + 82);
            x += toggleButton.getWidth() + 6;
            this.addRenderableWidget((GuiEventListener)toggleButton);
        }
        this.updateRedstoneTabRect(0.0f);
        this.redstoneModeIgnored.setX(this.redstoneTabRect.getX() + 28);
        this.redstoneModeIgnored.setY(this.redstoneTabRect.getY() + 22);
        this.redstoneModeLow.setX(this.redstoneModeIgnored.getX() + this.redstoneModeIgnored.getWidth() + 4);
        this.redstoneModeLow.setY(this.redstoneModeIgnored.getY());
        this.redstoneModeHigh.setX(this.redstoneModeLow.getX() + this.redstoneModeLow.getWidth() + 4);
        this.redstoneModeHigh.setY(this.redstoneModeLow.getY());
        this.addRenderableWidget((GuiEventListener)this.redstoneModeIgnored);
        this.addRenderableWidget((GuiEventListener)this.redstoneModeLow);
        this.addRenderableWidget((GuiEventListener)this.redstoneModeHigh);
        this.addRenderableWidget(new RedstoneTabOpenCloseHandler());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.hoveredSlot != null && !this.hoveredSlot.hasItem() && this.hoveredSlot instanceof UpgradeSlot) {
            guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"gui.moderndynamics.tooltip.slot.upgrade"), Component.translatable((String)"gui.moderndynamics.tooltip.slot.upgrade_desc1").withStyle(ChatFormatting.GOLD), Component.translatable((String)"gui.moderndynamics.tooltip.slot.upgrade_desc2").withStyle(ChatFormatting.GOLD)), Optional.empty(), mouseX, mouseY);
        } else {
            super.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        ConfigSlot configSlot;
        if (slot instanceof ConfigSlot && !(configSlot = (ConfigSlot)slot).isActive()) {
            return;
        }
        if (slot instanceof FluidConfigSlot) {
            FluidConfigSlot fluidConfigSlot = (FluidConfigSlot)slot;
            FluidVariant variant = fluidConfigSlot.getFilter();
            if (!variant.isBlank()) {
                FluidAttachedIoScreen.drawFluidInGui(guiGraphics, fluidConfigSlot.getFilter(), slot.x, slot.y);
            }
        } else {
            super.renderSlot(guiGraphics, slot);
        }
    }

    protected void addToggleButtons(List<CycleSettingButton<?>> toggleButtons) {
        if (((AttachedIoMenu)this.menu).isSettingSupported(Setting.FILTER_INVERSION)) {
            toggleButtons.add(new CycleSettingButton<FilterInversionMode>(CycleSettingButton.FILTER_INVERSION, ((AttachedIoMenu)this.menu).getFilterMode(), ((AttachedIoMenu)this.menu)::setFilterMode));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderRedstoneTabBg(guiGraphics, partialTick);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(TEXTURE, this.leftPos + -24, this.topPos + 4, 0, 0, 24, 77);
        guiGraphics.blit(TEXTURE, this.leftPos + -24, this.topPos + 4 + 82 - 5, 0, 199, 24, 5);
        for (Slot slot : ((AttachedIoMenu)this.getMenu()).slots) {
            ConfigSlot cfg;
            if (!(slot instanceof ConfigSlot) && !(slot instanceof UpgradeSlot)) continue;
            if (slot instanceof ConfigSlot && !(cfg = (ConfigSlot)slot).isActive()) {
                guiGraphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 216, 162, 18, 18);
                continue;
            }
            guiGraphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 7, 122, 18, 18);
        }
    }

    private void renderRedstoneTabBg(GuiGraphics guiGraphics, float partialTicks) {
        this.updateRedstoneTabRect(partialTicks);
        RenderSystem.setShaderColor((float)0.81f, (float)0.14f, (float)0.04f, (float)1.0f);
        int tabX = this.redstoneTabRect.getX();
        int tabY = this.redstoneTabRect.getY();
        int tabWidth = this.redstoneTabRect.getWidth();
        int tabHeight = this.redstoneTabRect.getHeight();
        int tabRight = tabX + tabWidth;
        int tabBottom = tabY + tabHeight;
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX, tabY, 0, 0, 4, 4);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabRight - 4, tabY, 252, 0, 4, 4);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabRight - 4, tabBottom - 4, 252, 252, 4, 4);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX, tabBottom - 4, 0, 252, 4, 4);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX + 4, tabY, tabWidth - 8, 4, 4.0f, 0.0f, 248, 4, 256, 256);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabRight - 4, tabY + 4, 4, tabHeight - 8, 252.0f, 4.0f, 4, 248, 256, 256);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX + 4, tabBottom - 4, tabWidth - 8, 4, 4.0f, 252.0f, 248, 4, 256, 256);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX, tabY + 4, 4, tabHeight - 8, 0.0f, 4.0f, 4, 248, 256, 256);
        guiGraphics.blit(TAB_RIGHT_TEXTURE, tabX + 4, tabY + 4, 4, 4, tabWidth - 8, tabHeight - 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Rect2i scissorRect = this.getRedstoneTabScissorRect();
        RenderSystem.enableScissor((int)scissorRect.getX(), (int)scissorRect.getY(), (int)scissorRect.getWidth(), (int)scissorRect.getHeight());
        this.redstoneModeIgnored.setScissorRect(scissorRect);
        this.redstoneModeLow.setScissorRect(scissorRect);
        this.redstoneModeHigh.setScissorRect(scissorRect);
        guiGraphics.fill(this.redstoneModeIgnored.getX() - 4, this.redstoneModeIgnored.getY() - 4, this.redstoneModeHigh.getX() + this.redstoneModeHigh.getWidth() + 4, this.redstoneModeHigh.getY() + this.redstoneModeHigh.getHeight() + 4, -10416123);
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.REDSTONE), tabX + 2, tabY + 3);
        MutableComponent header = Component.translatable((String)"gui.moderndynamics.setting.redstone_control.header");
        guiGraphics.drawString(this.font, (Component)header, tabX + 4 + 16, tabY + 4 + 4, 14797103);
        MutableComponent subHeaderStatus = Component.translatable((String)"gui.moderndynamics.setting.redstone_control.status_header");
        guiGraphics.drawString(this.font, (Component)subHeaderStatus, tabX + 4 + 4, tabY + 4 + 42, 11186104);
        MutableComponent enabledStatusText = ((AttachedIoMenu)this.menu).isEnabledViaRedstone() ? Component.translatable((String)"gui.moderndynamics.setting.redstone_control.enabled") : Component.translatable((String)"gui.moderndynamics.setting.redstone_control.disabled");
        guiGraphics.drawString(this.font, (Component)enabledStatusText, tabX + 4 + 12, tabY + 4 + 54, 0, false);
        MutableComponent subHeaderSetting = Component.translatable((String)"gui.moderndynamics.setting.redstone_control.signal_required_header");
        guiGraphics.drawString(this.font, (Component)subHeaderSetting, tabX + 4 + 4, tabY + 4 + 66, 11186104);
        guiGraphics.drawString(this.font, ((AttachedIoMenu)this.menu).getRedstoneMode().getTranslation(), tabX + 4 + 12, tabY + 4 + 78, 0, false);
        RenderSystem.disableScissor();
    }

    public void appendExclusionZones(Consumer<Rect2i> consumer) {
        consumer.accept(new Rect2i(this.leftPos + -24, this.topPos + 4, 24, 82));
        consumer.accept(this.redstoneTabRect);
    }

    private void updateRedstoneTabRect(float partialTicks) {
        GuiEventListener guiEventListener;
        int tabX = this.leftPos + this.imageWidth;
        int tabY = this.topPos + 4;
        float open = this.getCurrentRedstoneTabOpen(partialTicks);
        int tabWidth = Math.round(Mth.lerp((float)open, (float)22.0f, (float)112.0f));
        int tabHeight = Math.round(Mth.lerp((float)open, (float)22.0f, (float)97.0f));
        this.redstoneTabRect = new Rect2i(tabX, tabY, tabWidth, tabHeight);
        for (RedstoneModeButton button : this.redstoneButtons) {
            button.visible = open > 0.0f;
        }
        if (open <= 0.0f && (guiEventListener = this.getFocused()) instanceof RedstoneModeButton) {
            RedstoneModeButton button = (RedstoneModeButton)guiEventListener;
            button.setFocused(false);
            this.setFocused(null);
        }
    }

    private Rect2i getRedstoneTabScissorRect() {
        Rect2i tabRect = this.redstoneTabRect;
        double scale = this.minecraft.getWindow().getGuiScale();
        return new Rect2i((int)((double)(tabRect.getX() + 4) * scale), (int)((double)(this.height - (tabRect.getY() + tabRect.getHeight() - 4)) * scale), (int)((double)(tabRect.getWidth() - 8) * scale), (int)((double)(tabRect.getHeight() - 8) * scale));
    }

    private float getCurrentRedstoneTabOpen(float partialTicks) {
        float result = this.redstoneTabCurrentOpen;
        result = this.redstoneTabOpen ? (result += partialTicks * 0.2f) : (result -= partialTicks * 0.2f);
        return Mth.clamp((float)result, (float)0.0f, (float)1.0f);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.redstoneTabOpen) {
            this.redstoneTabCurrentOpen += 0.2f;
            if (this.redstoneTabCurrentOpen > 1.0f) {
                this.redstoneTabCurrentOpen = 1.0f;
            }
        } else {
            this.redstoneTabCurrentOpen -= 0.2f;
            if (this.redstoneTabCurrentOpen < 0.0f) {
                this.redstoneTabCurrentOpen = 0.0f;
            }
        }
        this.updateRedstoneTabRect(0.0f);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        if (!super.hasClickedOutside(mouseX, mouseY, guiLeft, guiTop, mouseButton)) {
            return false;
        }
        return !UpgradePanel.isInside(mouseX - (double)this.leftPos, mouseY - (double)this.topPos) && !this.isInRedstoneTabRect(mouseX, mouseY);
    }

    private boolean isInRedstoneTabRect(double mouseX, double mouseY) {
        return mouseX >= (double)this.redstoneTabRect.getX() && mouseY >= (double)this.redstoneTabRect.getY() && mouseX < (double)(this.redstoneTabRect.getX() + this.redstoneTabRect.getWidth()) && mouseY < (double)(this.redstoneTabRect.getY() + this.redstoneTabRect.getHeight());
    }

    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    private class RedstoneTabOpenCloseHandler
    implements GuiEventListener,
    NarratableEntry,
    Renderable {
        private RedstoneTabOpenCloseHandler() {
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (AttachedIoScreen.this.isInRedstoneTabRect(mouseX, mouseY) && button == 0) {
                AttachedIoScreen.this.redstoneTabOpen = !AttachedIoScreen.this.redstoneTabOpen;
                return true;
            }
            return false;
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void setFocused(boolean focused) {
        }

        public boolean isFocused() {
            return false;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (AttachedIoScreen.this.redstoneTabCurrentOpen <= 0.0f && AttachedIoScreen.this.isInRedstoneTabRect(mouseX, mouseY)) {
                List<MutableComponent> lines = List.of(Component.translatable((String)"gui.moderndynamics.setting.redstone_control.header").withStyle(ChatFormatting.WHITE), ((AttachedIoMenu)AttachedIoScreen.this.menu).getRedstoneMode().getTranslation().copy().withStyle(ChatFormatting.YELLOW));
                guiGraphics.renderComponentTooltip(AttachedIoScreen.this.font, lines, mouseX, mouseY);
            }
        }
    }
}

