/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.attached;

import dev.technici4n.moderndynamics.attachment.settings.FilterDamageMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterModMode;
import dev.technici4n.moderndynamics.attachment.settings.FilterNbtMode;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class ItemCachedFilter {
    private final Set<ItemVariant> listedVariants;
    private final Set<Item> listedItems;
    private final FilterInversionMode filterInversion;
    private final FilterDamageMode filterDamage;
    private final FilterNbtMode filterNbt;
    private final FilterModMode filterMod;
    @Nullable
    private Set<String> listedMods;

    public ItemCachedFilter(List<ItemVariant> filterConfig, FilterInversionMode filterInversion, FilterDamageMode filterDamage, FilterNbtMode filterNbt, FilterModMode filterMod) {
        this.filterInversion = filterInversion;
        this.filterDamage = filterDamage;
        this.filterNbt = filterNbt;
        this.filterMod = filterMod;
        this.listedVariants = new HashSet<ItemVariant>(filterConfig.size());
        this.listedItems = Collections.newSetFromMap(new IdentityHashMap());
        for (ItemVariant variant : filterConfig) {
            if (variant.isBlank()) continue;
            this.listedVariants.add(variant);
            this.listedItems.add(variant.getItem());
        }
    }

    private boolean isItemListed(ItemVariant variant) {
        boolean itemIsListed = false;
        if (this.filterMod == FilterModMode.INCLUDE_ALL_OF_MOD) {
            if (this.getListedMods().contains(ItemCachedFilter.getModId(variant))) {
                itemIsListed = true;
            }
        } else {
            itemIsListed = this.filterNbt == FilterNbtMode.RESPECT_NBT ? this.listedVariants.contains(variant) : this.listedItems.contains(variant.getItem());
        }
        if (!itemIsListed) {
            // empty if block
        }
        return itemIsListed;
    }

    public boolean matchesItem(ItemVariant variant) {
        return this.isItemListed(variant) == (this.filterInversion == FilterInversionMode.WHITELIST);
    }

    private Set<String> getListedMods() {
        if (this.listedMods == null) {
            this.listedMods = new HashSet<String>();
            for (ItemVariant variant : this.listedVariants) {
                this.listedMods.add(ItemCachedFilter.getModId(variant));
            }
        }
        return this.listedMods;
    }

    public boolean matchesFluid(FluidVariant variant) {
        return false;
    }

    private static String getModId(ItemVariant variant) {
        return BuiltInRegistries.ITEM.getKey((Object)variant.getItem()).getNamespace();
    }

    private static String getModId(FluidVariant variant) {
        return BuiltInRegistries.FLUID.getKey((Object)variant.getFluid()).getNamespace();
    }

    @FunctionalInterface
    static interface NbtMatcher {
        public boolean matches(@Nullable CompoundTag var1, @Nullable CompoundTag var2);
    }
}

