/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.requestsystem;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.requestsystem.requests.AbstractRequest;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.ICustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;

public class CustomizableRequest<R extends ICustomizableRequestable>
extends AbstractRequest<R> {
    public CustomizableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull R requested) {
        super(requester, token, requested);
    }

    public CustomizableRequest(@NotNull IRequester requester, @NotNull IToken<?> token, @NotNull RequestState state, @NotNull R requested) {
        super(requester, token, state, requested);
    }

    @NotNull
    public Component getShortDisplayString() {
        ICustomizableRequestable request = (ICustomizableRequestable)this.getRequest();
        IRequestableObject object = request.getObject();
        if (object != null) {
            return object.getShortDisplayString();
        }
        return Component.literal((String)("Unknown request id: " + String.valueOf(request.getId())));
    }

    @NotNull
    public Component getLongDisplayString() {
        ICustomizableRequestable request = (ICustomizableRequestable)this.getRequest();
        IRequestableObject object = request.getObject();
        if (object != null) {
            return object.getLongDisplayString();
        }
        return Component.literal((String)("Unknown request id: " + String.valueOf(request.getId())));
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        IRequestableObject object = ((ICustomizableRequestable)this.getRequest()).getObject();
        return object != null ? object.getDisplayStacks() : Collections.emptyList();
    }

    @NotNull
    public ResourceLocation getDisplayIcon() {
        IRequestableObject object = ((ICustomizableRequestable)this.getRequest()).getObject();
        return object != null ? object.getDisplayIcon() : super.getDisplayIcon();
    }

    public List<MutableComponent> getResolverToolTip(IColonyView colony) {
        IRequestableObject object = ((ICustomizableRequestable)this.getRequest()).getObject();
        return object != null ? object.getResolverToolTip(colony) : super.getResolverToolTip(colony);
    }
}

