/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.IColony;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.colony.BuildingCost;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public abstract class BatchBuildingCostsMessage
extends AbstractMessage {
    private final ResourceKey<Level> dimensionId;
    private final int colonyId;
    private final List<BuildingCost> buildings;

    public BatchBuildingCostsMessage(IColony colony) {
        this.dimensionId = colony.getDimension();
        this.colonyId = colony.getID();
        this.buildings = new ArrayList<BuildingCost>();
    }

    public BatchBuildingCostsMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.dimensionId = buffer.readResourceKey(Registries.DIMENSION);
        this.colonyId = buffer.readInt();
        this.buildings = (List)buffer.readCollection(ArrayList::new, SerializationHelper.reader(BuildingCost::decode));
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeResourceKey(this.dimensionId);
        buffer.writeInt(this.colonyId);
        buffer.writeCollection(this.buildings, SerializationHelper.writer(BuildingCost::encode));
    }

    public ResourceKey<Level> getDimensionId() {
        return this.dimensionId;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public List<BuildingCost> getBuildings() {
        return this.buildings;
    }
}

