/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModuleView;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.network.message.BuildingModuleMessage;

public class AssignIdListMessage
extends BuildingModuleMessage {
    public static final CustomPacketPayload.Type<AssignIdListMessage> TYPE = new CustomPacketPayload.Type(MineColoniesTweaks.rl("assign_id_list"));
    private final Function function;
    private final Collection<ResourceLocation> ids;

    public AssignIdListMessage(IIdListModuleView module, Function function, Collection<ResourceLocation> ids) {
        super(module);
        this.function = function;
        this.ids = ids.stream().toList();
    }

    public AssignIdListMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.function = (Function)buffer.readEnum(Function.class);
        this.ids = buffer.readList(FriendlyByteBuf::readResourceLocation);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeEnum((Enum)this.function);
        buffer.writeCollection(this.ids, FriendlyByteBuf::writeResourceLocation);
    }

    @Override
    public void handle(IPayloadContext context) {
        super.handle(context);
        IBuildingModule iBuildingModule = this.getModulePos().getModule();
        if (iBuildingModule instanceof IIdListModule) {
            IIdListModule module = (IIdListModule)iBuildingModule;
            if (this.function == Function.CLEAR) {
                module.clearIds();
            } else if (this.function == Function.ADD) {
                module.addIds(this.ids);
            } else if (this.function == Function.REMOVE) {
                module.removeIds(this.ids);
            }
        }
    }

    public CustomPacketPayload.Type<AssignIdListMessage> type() {
        return TYPE;
    }

    public Function getFunction() {
        return this.function;
    }

    public Collection<ResourceLocation> getIds() {
        return this.ids;
    }

    public static enum Function {
        CLEAR,
        ADD,
        REMOVE;

    }
}

