/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.network.message.BuildingModuleMessage;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class AssignFilterableItemsMessage
extends BuildingModuleMessage {
    public static final CustomPacketPayload.Type<AssignFilterableItemsMessage> TYPE = new CustomPacketPayload.Type(MineColoniesTweaks.rl("assign_filterable_items"));
    private final Function function;
    private final List<ItemStorage> storages;

    public AssignFilterableItemsMessage(IItemListModuleView module, Function function, Iterable<ItemStorage> storages) {
        super((IBuildingModuleView)module);
        this.function = function;
        this.storages = ImmutableList.copyOf(storages);
    }

    public AssignFilterableItemsMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.function = (Function)buffer.readEnum(Function.class);
        this.storages = buffer.readList(SerializationHelper::deserialize);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeEnum((Enum)this.function);
        buffer.writeCollection(this.storages, SerializationHelper::serialize);
    }

    @Override
    public void handle(IPayloadContext context) {
        super.handle(context);
        IBuildingModule iBuildingModule = this.getModulePos().getModule();
        if (iBuildingModule instanceof ItemListModule) {
            ItemListModule module = (ItemListModule)iBuildingModule;
            if (this.function == Function.ADD) {
                this.storages.forEach(arg_0 -> ((ItemListModule)module).addItem(arg_0));
            } else if (this.function == Function.REMOVE) {
                this.storages.forEach(arg_0 -> ((ItemListModule)module).removeItem(arg_0));
            }
        }
    }

    public CustomPacketPayload.Type<AssignFilterableItemsMessage> type() {
        return TYPE;
    }

    public Function getFunction() {
        return this.function;
    }

    public List<ItemStorage> getStorages() {
        return this.storages;
    }

    public static enum Function {
        CLEAR,
        ADD,
        REMOVE;

    }
}

