/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IEntityListModule;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModule;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksDataComponents;

public class ItemCopyScroll
extends Item {
    public static final Component MESSAGE_NO_DATA = Component.translatable((String)"item.minecolonies_tweaks.copyscroll.no_data");
    public static final Component MESSAGE_CLEARED = Component.translatable((String)"item.minecolonies_tweaks.copyscroll.cleared");
    public static final List<Component> TOOLTIPS = Arrays.asList(Component.translatable((String)"item.minecolonies_tweaks.copyscroll.tooltip1"), Component.translatable((String)"item.minecolonies_tweaks.copyscroll.tooltip2"), Component.translatable((String)"item.minecolonies_tweaks.copyscroll.tooltip3"));

    public ItemCopyScroll(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.addAll(TOOLTIPS);
        CopyData data = (CopyData)stack.get(MCTweaksDataComponents.COPYSCROLL_DATA);
        if (data == null) {
            return;
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"item.minecolonies_tweaks.copyscroll.data", (Object[])new Object[]{Component.empty().append(data.name()).withStyle(ChatFormatting.DARK_PURPLE)}));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide() && player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            stack.remove(MCTweaksDataComponents.COPYSCROLL_DATA);
            player.sendSystemMessage(MESSAGE_CLEARED);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding be = (AbstractTileEntityColonyBuilding)blockEntity;
            if (context.getLevel().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            IBuilding building = be.getBuilding();
            if (building == null) {
                return InteractionResult.PASS;
            }
            Player player = context.getPlayer();
            if (player == null) {
                return InteractionResult.PASS;
            }
            RegistryAccess registryAccess = player.registryAccess();
            if (player.isShiftKeyDown()) {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                MutableComponent names = Component.empty();
                for (BuildingEntry.ModuleProducer moduleProducer : BuildingEntry.getALlModuleProducers().values()) {
                    IPersistentModule persistentModule;
                    IBuildingModule module;
                    if (!building.hasModule(moduleProducer) || !((module = building.getModule(moduleProducer)) instanceof IPersistentModule) || !ItemCopyScroll.canCopy(persistentModule = (IPersistentModule)module)) continue;
                    Component text = ItemCopyScroll.getModuleViewText(module);
                    entries.add(new Entry(moduleProducer.key, ItemCopyScroll.copy((HolderLookup.Provider)registryAccess, persistentModule)));
                    if (entries.size() > 1) {
                        names.append(", ");
                    }
                    names.append((Component)Component.translatable((String)"'%s'", (Object[])new Object[]{text}));
                }
                stack.set(MCTweaksDataComponents.COPYSCROLL_DATA, (Object)new CopyData((Component)BuildingUtils.getDisplayName(building), entries));
                player.sendSystemMessage((Component)Component.translatable((String)"item.minecolonies_tweaks.copyscroll.copied", (Object[])new Object[]{entries.size(), names}));
            } else {
                CopyData data = (CopyData)stack.get(MCTweaksDataComponents.COPYSCROLL_DATA);
                if (data == null) {
                    player.sendSystemMessage(MESSAGE_NO_DATA);
                    return InteractionResult.SUCCESS;
                }
                List<Entry> entries = data.entries();
                int pasted = 0;
                MutableComponent names = Component.empty();
                for (Entry entry : entries) {
                    IPersistentModule persistentModule;
                    IBuildingModule module;
                    BuildingEntry.ModuleProducer producer = BuildingEntry.getProducer((String)entry.key);
                    if (producer == null || !building.hasModule(producer) || !((module = building.getModule(producer)) instanceof IPersistentModule) || !ItemCopyScroll.canCopy(persistentModule = (IPersistentModule)module)) continue;
                    try {
                        Component text = ItemCopyScroll.getModuleViewText(module);
                        ItemCopyScroll.paste(persistentModule, (HolderLookup.Provider)registryAccess, entry.tag);
                        if (++pasted > 1) {
                            names.append(", ");
                        }
                        names.append((Component)Component.translatable((String)"'%s'", (Object[])new Object[]{text}));
                    }
                    catch (Exception exception) {}
                }
                player.sendSystemMessage((Component)Component.translatable((String)"item.minecolonies_tweaks.copyscroll.pasted", (Object[])new Object[]{pasted, names}));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static CompoundTag copy(HolderLookup.Provider provider, IPersistentModule module) {
        CompoundTag tag = new CompoundTag();
        module.serializeNBT(provider, tag);
        return tag;
    }

    public static void paste(IPersistentModule module, HolderLookup.Provider provider, CompoundTag tag) {
        ItemCopyScroll.onPastePre(module);
        module.deserializeNBT(provider, tag);
        module.markDirty();
        ItemCopyScroll.onPastePost(module);
    }

    private static void onPastePre(IPersistentModule module) {
        if (module instanceof ICraftingBuildingModule) {
            ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)module;
            for (IToken token : new ArrayList(craftingModule.getRecipes())) {
                craftingModule.removeRecipe(token);
            }
        }
    }

    private static void onPastePost(IPersistentModule module) {
        if (module instanceof ICraftingBuildingModule) {
            ICraftingBuildingModule craftingModule = (ICraftingBuildingModule)module;
            IRequestManager requestManager = craftingModule.getBuilding().getColony().getRequestManager();
            for (IToken token : new ArrayList(craftingModule.getRecipes())) {
                IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get((Object)token);
                if (recipeStorage == null) continue;
                List<ItemStack> allOutputs = Stream.concat(Stream.of(recipeStorage.getPrimaryOutput()), recipeStorage.getAlternateOutputs().stream()).filter(stack -> !stack.isEmpty()).toList();
                requestManager.onColonyUpdate(request -> {
                    IRequestable patt0$temp = request.getRequest();
                    if (!(patt0$temp instanceof IDeliverable)) return false;
                    IDeliverable delivery = (IDeliverable)patt0$temp;
                    if (!allOutputs.stream().anyMatch(i -> delivery.matches(i))) return false;
                    return true;
                });
            }
        }
    }

    public static boolean canCopy(IPersistentModule module) {
        return module instanceof ISettingsModule || module instanceof IMinimumStockModule || module instanceof IEntityListModule || module instanceof IItemListModule || module instanceof RestaurantMenuModule || module instanceof ICraftingBuildingModule || module instanceof IMaximumStockModule || module instanceof IIdListModule;
    }

    public static Component getModuleViewText(IBuildingModule module) {
        IBuildingModuleView view = BuildingEntry.produceViewWithoutBuilding((String)module.getProducer().key);
        if (view != null) {
            try {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), module.getBuilding().getColony().getWorld().registryAccess());
                module.serializeToView(buf, true);
                view.deserialize(buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return view.getDesc();
        }
        return Component.literal((String)module.getProducer().key);
    }

    public record CopyData(Component name, List<Entry> entries) {
        public static final Codec<CopyData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(CopyData::name), (App)Codec.list(Entry.CODEC).fieldOf("entries").forGetter(CopyData::entries)).apply((Applicative)builder, CopyData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CopyData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, CopyData::name, (StreamCodec)Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), CopyData::entries, CopyData::new);
    }

    public record Entry(String key, CompoundTag tag) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("key").forGetter(Entry::key), (App)CompoundTag.CODEC.fieldOf("tag").forGetter(Entry::tag)).apply((Applicative)builder, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Entry::key, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, Entry::tag, Entry::new);
    }
}

