/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class CustomizableRecipeStorageFactory
implements IFactory<IToken<?>, CustomizableRecipeStorage> {
    public static final TypeToken<CustomizableRecipeStorage> OUTPUT_TYPE = TypeToken.of(CustomizableRecipeStorage.class);
    public static final TypeToken<IToken<?>> INPUT_TYPE = TypeConstants.ITOKEN;
    public static final String TAG_IMPL = "impl";
    public static final String TAG_TOKEN = "token";

    @NotNull
    public TypeToken<CustomizableRecipeStorage> getFactoryOutputType() {
        return OUTPUT_TYPE;
    }

    @NotNull
    public TypeToken<? extends IToken<?>> getFactoryInputType() {
        return INPUT_TYPE;
    }

    @NotNull
    public CustomizableRecipeStorage getNewInstance(@NotNull IFactoryController factoryController, @NotNull IToken<?> input, Object ... context) throws IllegalArgumentException {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)context[0];
        return new CustomizableRecipeStorage(input, impl);
    }

    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CustomizableRecipeStorage output) {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_IMPL, (Tag)CustomizedRecipeStorageRegistry.INSTANCE.serialize(provider, controller, output.getImpl()));
        tag.put(TAG_TOKEN, (Tag)controller.serializeTag(provider, output.getToken()));
        return tag;
    }

    @NotNull
    public CustomizableRecipeStorage deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag) throws Throwable {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)CustomizedRecipeStorageRegistry.INSTANCE.deserialize(provider, controller, tag.getCompound(TAG_IMPL));
        IToken token = (IToken)controller.deserializeTag(provider, tag.getCompound(TAG_TOKEN));
        return new CustomizableRecipeStorage(token, impl);
    }

    public void serialize(@NotNull IFactoryController controller, @NotNull CustomizableRecipeStorage output, RegistryFriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)CustomizedRecipeStorageRegistry.INSTANCE.serialize((HolderLookup.Provider)buffer.registryAccess(), controller, output.getImpl()));
        controller.serialize(buffer, output.getToken());
    }

    @NotNull
    public CustomizableRecipeStorage deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
        ICustomizedRecipeStorage impl = (ICustomizedRecipeStorage)CustomizedRecipeStorageRegistry.INSTANCE.deserialize((HolderLookup.Provider)buffer.registryAccess(), controller, buffer.readNbt());
        IToken token = (IToken)controller.deserialize(buffer);
        return new CustomizableRecipeStorage(token, impl);
    }

    public short getSerializationId() {
        return 10704;
    }
}

