/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.command;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.function.ToIntBiFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class CitizenCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.literal((String)"citizens");
        command.then(SaturationCommands.register());
        return command;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name, boolean needPermission, ToIntBiFunction<CommandContext<CommandSourceStack>, AbstractEntityCitizen> func) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(IMCCommand.newArgument((String)"colonyID", (ArgumentType)IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument((String)"citizenID", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CitizenCommands.run((CommandContext<CommandSourceStack>)context, needPermission, func))));
    }

    public static int run(CommandContext<CommandSourceStack> context, boolean needPermission, ToIntBiFunction<CommandContext<CommandSourceStack>, AbstractEntityCitizen> func) {
        if (needPermission && !((CommandSourceStack)context.getSource()).hasPermission(2)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.notop"), true);
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, ((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).hasPermission(4)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        return func.applyAsInt(context, (AbstractEntityCitizen)optionalEntityCitizen.get());
    }

    public static class SaturationCommands {
        public static LiteralArgumentBuilder<CommandSourceStack> register() {
            LiteralArgumentBuilder command = Commands.literal((String)"saturation");
            command.then(SaturationCommands.full());
            command.then(SaturationCommands.empty());
            return command;
        }

        private static LiteralArgumentBuilder<CommandSourceStack> full() {
            return CitizenCommands.literal("full", true, (context, citizen) -> {
                citizen.getCitizenData().setSaturation(20.0);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Done"), true);
                return 1;
            });
        }

        private static LiteralArgumentBuilder<CommandSourceStack> empty() {
            return CitizenCommands.literal("empty", true, (context, citizen) -> {
                citizen.getCitizenData().setSaturation(0.0);
                citizen.getCitizenData().setJustAte(false);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Done"), true);
                return 1;
            });
        }
    }
}

