/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BuildingUtils {
    public static boolean isUnlocked(IColony colony, BuildingEntry building, int level) {
        ResourceLocation hutResearch = colony.getResearchManager().getResearchEffectIdFrom((Block)building.getBuildingBlock());
        return !MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(hutResearch) || !(colony.getResearchManager().getResearchEffects().getEffectStrength(hutResearch) < (double)Math.max(1, level));
    }

    private static MutableComponent getDisplayName(BuildingEntry type, String customName, int level) {
        MutableComponent buildingName = Component.empty();
        buildingName.append((Component)(customName.isEmpty() ? Component.translatable((String)type.getBuildingBlock().getDescriptionId()) : Component.literal((String)customName)));
        if (BuildingUtils.hasLevel(type)) {
            buildingName.append(" ").append(String.valueOf(level));
        }
        return buildingName;
    }

    public static boolean hasLevel(BuildingEntry type) {
        return type != ModBuildings.stash.get() && type != ModBuildings.postBox.get();
    }

    @Nullable
    public static MutableComponent getDisplayName(IRequester requester) {
        if (requester instanceof IBuilding) {
            IBuilding building = (IBuilding)requester;
            return BuildingUtils.getDisplayName(building);
        }
        if (requester instanceof IBuildingView) {
            IBuildingView buildingView = (IBuildingView)requester;
            return BuildingUtils.getDisplayName(buildingView);
        }
        return null;
    }

    public static MutableComponent getDisplayName(IBuilding building) {
        return BuildingUtils.getDisplayName(building.getBuildingType(), building.getCustomName(), building.getBuildingLevel());
    }

    public static MutableComponent getDisplayName(IBuildingView buildingView) {
        return BuildingUtils.getDisplayName(buildingView.getBuildingType(), buildingView.getCustomName(), buildingView.getBuildingLevel());
    }

    private BuildingUtils() {
    }
}

