/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.view;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.client.gui.RenderUtils;

public class FluidIcon
extends Pane {
    protected static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    protected static final MutableComponent FIX_VANILLA_TOOLTIP = SpacerTextComponent.of((int)1);
    @Nullable
    protected FluidStack fluidStack;
    protected boolean tooltipUpdateScheduled = false;
    protected boolean showAmount = true;

    public FluidIcon() {
    }

    public FluidIcon(PaneParams params) {
        super(params);
        Fluid fluid;
        String fluidName = params.getString("fluid");
        if (fluidName != null && (fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fluidName))) != null) {
            int fluidAmount = params.getInteger("amount", 1);
            this.setFluid(new FluidStack(fluid, fluidAmount));
        }
        this.showAmount = params.getBoolean("showAmount", this.showAmount);
    }

    public void setFluid(FluidStack fluidStack) {
        this.clearDataAndScheduleTooltipUpdate();
        this.fluidStack = fluidStack;
        this.onFluidUpdate();
    }

    protected void onFluidUpdate() {
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public void setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
    }

    public boolean showAmount() {
        return this.showAmount;
    }

    public void clearDataAndScheduleTooltipUpdate() {
        this.fluidStack = null;
        this.tooltipUpdateScheduled = true;
    }

    protected boolean isFluidEmpty() {
        return this.fluidStack == null || this.fluidStack.isEmpty();
    }

    public boolean isDataEmpty() {
        return this.isFluidEmpty();
    }

    protected void updateTooltipIfNeeded() {
        if (this.tooltipUpdateScheduled) {
            Pane pane = this.onHover;
            if (pane instanceof Tooltip.AutomaticTooltip) {
                Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
                tooltip.setTextOld(this.getModifiedFluidStackTooltip());
            }
            this.tooltipUpdateScheduled = false;
        }
    }

    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (!this.isDataEmpty()) {
            PoseStack ms = target.pose();
            ms.pushPose();
            ms.translate((float)this.x, (float)this.y, 0.0f);
            RenderUtils.renderFluid(ms, 16, 16, this.fluidStack);
            ms.popPose();
        }
    }

    public void onUpdate() {
        if (this.onHover == null && !this.isFluidEmpty()) {
            new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane((Pane)this).build().setTextOld(this.getModifiedFluidStackTooltip());
        }
    }

    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlags, int nameOffset) {
        return nameOffset;
    }

    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlags, int prevTooltipSize) {
        return prevTooltipSize;
    }

    public List<Component> getModifiedFluidStackTooltip() {
        TooltipFlag.Default tooltipFlags;
        if (this.isDataEmpty()) {
            return Collections.emptyList();
        }
        TooltipFlag.Default default_ = tooltipFlags = this.mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        if (this.mc.player.isCreative()) {
            tooltipFlags = tooltipFlags.asCreative();
        }
        Fluid fluid = this.fluidStack.getFluid();
        ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
        String namespace = id.getNamespace();
        int nameOffset = 1;
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        tooltipList.add(this.fluidStack.getHoverName());
        if (tooltipFlags.isAdvanced()) {
            tooltipList.add((Component)Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (this.showAmount()) {
            tooltipList.add((Component)Component.literal((String)(String.format("%,d", this.fluidStack.getAmount()) + " mB")).withStyle(ChatFormatting.GRAY));
        }
        tooltipList.add((Component)Component.literal((String)ModList.get().getModContainerById(namespace).map(f -> f.getModInfo().getDisplayName()).orElse(namespace)).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        nameOffset = this.modifyTooltipName(tooltipList, (TooltipFlag)tooltipFlags, nameOffset);
        int prevTooltipSize = tooltipList.size();
        if (tooltipFlags.isAdvanced() && tooltipFlags.isCreative()) {
            int c = nameOffset + 1;
            BuiltInRegistries.FLUID.getHolder(id).map(Holder::tags).ifPresent(tags -> tags.forEach(tag -> tooltipList.add(c, (Component)FluidIcon.wrapShift(Component.literal((String)("#" + String.valueOf(tag.location()))).withStyle(ChatFormatting.DARK_PURPLE)))));
        }
        if ((prevTooltipSize = this.appendTooltip(tooltipList, (TooltipFlag)tooltipFlags, prevTooltipSize)) != tooltipList.size()) {
            tooltipList.add((Component)ToggleableTextComponent.ofNegated(Screen::hasShiftDown, (MutableComponent)Component.empty()));
            tooltipList.add((Component)ToggleableTextComponent.ofNegated(Screen::hasShiftDown, (MutableComponent)Component.translatable((String)"blockui.tooltip.item_additional_info", (Object[])new Object[]{Component.translatable((String)"key.keyboard.left.shift")}).withStyle(ChatFormatting.GOLD)));
        }
        tooltipList.add(nameOffset, (Component)FIX_VANILLA_TOOLTIP);
        return tooltipList;
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped) {
        return ToggleableTextComponent.of(Screen::hasShiftDown, (MutableComponent)wrapped);
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped, boolean shouldWrap) {
        return shouldWrap ? ToggleableTextComponent.of(Screen::hasShiftDown, (MutableComponent)wrapped) : wrapped;
    }
}

