/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.client.gui.WindowSelectRes;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockEntry;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModuleView;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class MaximumStockModuleWindow
extends AbstractModuleWindow<IMaximumStockModuleView> {
    private static final String LABEL_ADD = "com.minecolonies.coremod.gui.warehouse.add";
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private static final String LABEL_STACKS = "minecolonies_tweaks.gui.maximumstock.stacks";
    private final ScrollingList resourceList;
    private final IMaximumStockModuleView moduleView;
    private final List<IMaximumStockEntry> entries;
    private Button confirmButton;

    public MaximumStockModuleWindow(IMaximumStockModuleView moduleView) {
        super((IBuildingModuleView)moduleView, MineColoniesTweaks.rl("gui/layouthuts/layoutmaximumstock.xml"));
        this.moduleView = moduleView;
        this.entries = new ArrayList<IMaximumStockEntry>();
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return MaximumStockModuleWindow.this.entries.size();
            }

            public void updateElement(int index, Pane rowPane) {
                IMaximumStockEntry entry = MaximumStockModuleWindow.this.entries.get(index);
                ItemStack resource = entry.stack();
                resource.setCount(resource.getMaxStackSize());
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.getHoverName());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(Component.literal((String)String.valueOf(entry.quantity())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        Button confirmButton = this.confirmButton;
        if (confirmButton != null) {
            confirmButton.setText(Component.literal((String)"X"));
            this.confirmButton = null;
        }
        if (button.getID().equals("removeStock")) {
            if (confirmButton == button) {
                int row = this.resourceList.getListElementIndexByPane((Pane)button);
                IMaximumStockEntry entry = this.entries.get(row);
                this.moduleView.removeMaximumStock(entry.stack());
                this.updateStockList();
            } else {
                this.confirmButton = button;
                this.confirmButton.setText(Component.translatable((String)"minecolonies_tweaks.gui.surely"));
            }
        } else if (button.getID().equals("addStock") && !this.moduleView.hasMaximumStockReachedLimit()) {
            new WindowSelectRes((BOWindow)this, this.moduleView.getDesc(), null, IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems(), (stack, qty) -> {
                this.moduleView.addMaximumStock((ItemStack)stack, (int)qty);
                this.updateStockList();
            }, true, (Component)Component.translatable((String)LABEL_STACKS)).open();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.entries.clear();
        this.entries.addAll(this.moduleView.getMaximumStocks());
        ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
        if (this.moduleView.hasMaximumStockReachedLimit()) {
            button.setText(Component.translatable((String)LABEL_LIMIT_REACHED));
            button.setImage(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"textures/gui/builderhut/builder_button_medium_disabled.png"));
        } else {
            button.setText(Component.translatable((String)LABEL_ADD));
            button.setImage(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"textures/gui/builderhut/builder_button_medium.png"));
        }
        Text kindsText = (Text)this.findPaneOfTypeByID("kinds", Text.class);
        kindsText.setText(Component.literal((String)(this.entries.size() + "/" + this.moduleView.getMaximumStockLimit())));
    }
}

