/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.registries;

import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.crafting.OutputDisplayStackModifier;
import steve_gall.minecolonies_tweaks.api.registries.DeferredRegisterHelper;

public class RecipeTypeRegister {
    @NotNull
    private final DeferredRegister<RecipeTypeEntry> recipeTypeEntires;

    public RecipeTypeRegister(@NotNull String modid) {
        this.recipeTypeEntires = DeferredRegisterHelper.recipeTypeEntries(modid);
    }

    public void register(@NotNull IEventBus bus) {
        this.getRecipeTypeEntries().register(bus);
    }

    public DeferredHolder<RecipeTypeEntry, RecipeTypeEntry> registerBuilder(@NotNull String name, @NotNull BiConsumer<ResourceLocation, RecipeTypeEntry.Builder> consumer) {
        return DeferredRegisterHelper.registerRecipeTypeEntry(this.getRecipeTypeEntries(), name, consumer);
    }

    public DeferredHolder<RecipeTypeEntry, RecipeTypeEntry> registerProducer(@NotNull String name, @NotNull BiFunction<ResourceLocation, IRecipeStorage, AbstractRecipeType<IRecipeStorage>> producer) {
        return this.registerBuilder(name, (id, builder) -> builder.setRecipeTypeProducer(r -> (AbstractRecipeType)producer.apply((ResourceLocation)id, (IRecipeStorage)r)));
    }

    public DeferredHolder<RecipeTypeEntry, RecipeTypeEntry> registerOutputStacks(@NotNull String name, final @NotNull Function<IRecipeStorage, List<ItemStack>> outputDisplayStacksFunc) {
        return this.registerProducer(name, (id, recipe) -> new OutputDisplayStackModifier(this, (ResourceLocation)id, (IRecipeStorage)recipe){

            @Override
            protected List<ItemStack> collectOutputDisplayStack(IRecipeStorage recipe) {
                return (List)outputDisplayStacksFunc.apply(recipe);
            }
        });
    }

    @NotNull
    public DeferredRegister<RecipeTypeEntry> getRecipeTypeEntries() {
        return this.recipeTypeEntires;
    }
}

