/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.core.common.crafting.CustomizableRecipeStorageFactory;

public interface ICustomizedRecipeStorage {
    public ResourceLocation getId();

    public List<ItemStorage> getInput();

    public int getGridSize();

    public ItemStack getPrimaryOutput();

    public List<ItemStack> getAlternateOutputs();

    public List<ItemStack> getSecondaryOutputs();

    public Block getIntermediate();

    public ResourceLocation getRecipeSource();

    public ResourceLocation getRecipeType();

    public ResourceKey<LootTable> getLootTable();

    public EquipmentTypeEntry getRequiredTool();

    default public IRecipeStorage wrap() {
        StandardFactoryController controller = StandardFactoryController.getInstance();
        TypeToken<CustomizableRecipeStorage> outputType = CustomizableRecipeStorageFactory.OUTPUT_TYPE;
        TypeToken<IToken<?>> inputType = CustomizableRecipeStorageFactory.INPUT_TYPE;
        IToken input = (IToken)controller.getNewInstance(inputType);
        return (IRecipeStorage)controller.getNewInstance(outputType, (Object)input, new Object[]{this});
    }
}

