/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building.module;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;

public class ModulePos {
    public static final String TAG_BUILDING_POS = "buildingPos";
    public static final String TAG_MODULE_NAME = "moduleName";
    public static final Codec<ModulePos> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BuildingPos.CODEC.fieldOf(TAG_BUILDING_POS).forGetter(ModulePos::getBuildingPos), (App)Codec.STRING.fieldOf(TAG_MODULE_NAME).forGetter(ModulePos::getModuleName)).apply((Applicative)builder, ModulePos::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ModulePos> STREAM_CODEC = StreamCodec.composite(BuildingPos.STREAM_CODEC, ModulePos::getBuildingPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, ModulePos::getModuleName, ModulePos::new);
    @NotNull
    private final BuildingPos buildingPos;
    private final String moduleName;

    public ModulePos(@NotNull CompoundTag tag) {
        this.buildingPos = new BuildingPos(tag.getCompound(TAG_BUILDING_POS));
        this.moduleName = tag.getString(TAG_MODULE_NAME);
    }

    public ModulePos(@NotNull FriendlyByteBuf buffer) {
        this.buildingPos = new BuildingPos(buffer);
        this.moduleName = buffer.readUtf();
    }

    public ModulePos(@NotNull BuildingPos buildingPos, @NotNull String moduleName) {
        this.buildingPos = buildingPos;
        this.moduleName = moduleName;
    }

    public ModulePos(@NotNull IBuildingModule module) {
        this(new BuildingPos(module.getBuilding()), module.getProducer().key);
    }

    public ModulePos(@NotNull IBuildingModuleView moduleView) {
        this(new BuildingPos(moduleView.getBuildingView()), moduleView.getProducer().key);
    }

    public int hashCode() {
        return Objects.hash(this.buildingPos, this.moduleName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ModulePos) {
            ModulePos other = (ModulePos)obj;
            return this.buildingPos.equals(other.buildingPos) && this.moduleName.equals(other.moduleName);
        }
        return false;
    }

    @Nullable
    public IBuildingModule getModule() {
        IBuilding building = this.getBuildingPos().getBuilding();
        if (building == null) {
            return null;
        }
        BuildingEntry.ModuleProducer producer = BuildingEntry.getProducer((String)this.moduleName);
        if (producer == null) {
            return null;
        }
        return building.getModule(producer);
    }

    @Nullable
    public IBuildingModuleView getModuleView() {
        IBuildingView building = this.getBuildingPos().getBuildingView();
        if (building == null) {
            return null;
        }
        BuildingEntry.ModuleProducer producer = BuildingEntry.getProducer((String)this.moduleName);
        if (producer == null) {
            return null;
        }
        return building.getModuleView(producer);
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_BUILDING_POS, (Tag)this.buildingPos.serializeNBT());
        tag.putString(TAG_MODULE_NAME, this.moduleName);
        return tag;
    }

    public void serializeBuffer(@NotNull FriendlyByteBuf buffer) {
        this.buildingPos.serializeBuffer(buffer);
        buffer.writeUtf(this.moduleName);
    }

    @NotNull
    public BuildingPos getBuildingPos() {
        return this.buildingPos;
    }

    @NotNull
    public ResourceKey<Level> getDimensionId() {
        return this.buildingPos.getDimensionId();
    }

    public int getColonyId() {
        return this.buildingPos.getColonyId();
    }

    @NotNull
    public BlockPos getBuildingId() {
        return this.buildingPos.getBuildingId();
    }

    @NotNull
    public String getModuleName() {
        return this.moduleName;
    }

    public int getX() {
        return this.getBuildingId().getX();
    }

    public int getY() {
        return this.getBuildingId().getY();
    }

    public int getZ() {
        return this.getBuildingId().getZ();
    }
}

