/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.CustomizableObjectRegistry;

public abstract class SimpleObjectRegistry<OBJECT>
extends CustomizableObjectRegistry<OBJECT, Entry<OBJECT>> {
    public <TYPED_OBJECT extends OBJECT> void register(@NotNull ResourceLocation id, @NotNull StaticSerializer<TYPED_OBJECT> serializer, @NotNull Deserializer<TYPED_OBJECT> deserializer) {
        super.register(new Entry<TYPED_OBJECT>(id, serializer, deserializer));
    }

    public <TYPED_OBJECT extends OBJECT> void register(@NotNull ResourceLocation id, @NotNull InstanceSerializer<TYPED_OBJECT> serializer, @NotNull Deserializer<TYPED_OBJECT> deserializer) {
        super.register(new Entry<Object>(id, (provider, controller, tag, object) -> serializer.serializeObject(object, provider, controller, tag), deserializer));
    }

    @Override
    protected void serializeObject(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag, @NotNull Entry<OBJECT> entry, @Nullable OBJECT object) {
        entry.serializer.serializeObject(provider, controller, tag, object);
    }

    @Override
    protected OBJECT deserializeObject(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag, @NotNull Entry<OBJECT> entry) {
        return entry.deserializer.deserializeObject(provider, controller, tag);
    }

    public static class Entry<OBJECT>
    extends CustomizableObjectRegistry.Entry {
        @NotNull
        private StaticSerializer<OBJECT> serializer;
        @NotNull
        private Deserializer<OBJECT> deserializer;

        public Entry(@NotNull ResourceLocation id, @NotNull StaticSerializer<OBJECT> serializer, @NotNull Deserializer<OBJECT> deserializer) {
            super(id);
            this.serializer = serializer;
            this.deserializer = deserializer;
        }
    }

    @FunctionalInterface
    public static interface StaticSerializer<OBJECT> {
        public void serializeObject(@NotNull HolderLookup.Provider var1, @NotNull IFactoryController var2, @NotNull CompoundTag var3, @Nullable OBJECT var4);
    }

    @FunctionalInterface
    public static interface Deserializer<OBJECT> {
        public OBJECT deserializeObject(@NotNull HolderLookup.Provider var1, @NotNull IFactoryController var2, @NotNull CompoundTag var3);
    }

    @FunctionalInterface
    public static interface InstanceSerializer<OBJECT> {
        public void serializeObject(@Nullable OBJECT var1, @NotNull HolderLookup.Provider var2, @NotNull IFactoryController var3, @NotNull CompoundTag var4);
    }
}

