/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.common.minecolonies;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.core.research.GlobalResearchEffect;
import com.minecolonies.core.research.ResearchEffectManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_tweaks.api.common.research.ResearchEffectChangedEventArgs;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchEffectManagerExtension;

@Mixin(value={ResearchEffectManager.class}, remap=false)
public abstract class ResearchEffectManagerMixin
implements ResearchEffectManagerExtension {
    @Unique
    private IColony minecolonies_tweaks$colony;
    @Shadow(remap=false)
    private Map<ResourceLocation, IResearchEffect> effectMap;

    @Shadow(remap=false)
    abstract double getEffectStrength(ResourceLocation var1);

    @Unique
    private boolean minecolonies_tweaks$isServerSide() {
        Level level = this.minecolonies_tweaks$colony.getWorld();
        return level != null && !level.isClientSide();
    }

    @Inject(method={"applyEffect"}, remap=false, at={@At(value="HEAD")}, cancellable=false)
    private void applyEffect(IResearchEffect effect, CallbackInfo ci) {
        if (this.minecolonies_tweaks$isServerSide() && effect instanceof GlobalResearchEffect) {
            GlobalResearchEffect effect2 = (GlobalResearchEffect)effect;
            ResourceLocation id = effect2.getId();
            double prev = this.getEffectStrength(id);
            double next = effect2.getEffect();
            if (!this.effectMap.containsKey(id) || prev != next) {
                NeoForge.EVENT_BUS.post((Event)new ResearchEffectChangedEventArgs(this.minecolonies_tweaks$colony, (IResearchEffect)effect2, prev, next));
            }
        }
    }

    @Inject(method={"removeAllEffects"}, remap=false, at={@At(value="HEAD")}, cancellable=false)
    private void removeAllEffects(CallbackInfo ci) {
        if (this.minecolonies_tweaks$isServerSide()) {
            for (Map.Entry<ResourceLocation, IResearchEffect> entry : this.effectMap.entrySet()) {
                IResearchEffect iResearchEffect = entry.getValue();
                if (!(iResearchEffect instanceof GlobalResearchEffect)) continue;
                GlobalResearchEffect effect2 = (GlobalResearchEffect)iResearchEffect;
                double prev = this.getEffectStrength(effect2.getId());
                NeoForge.EVENT_BUS.post((Event)new ResearchEffectChangedEventArgs(this.minecolonies_tweaks$colony, (IResearchEffect)effect2, prev, 0.0));
            }
        }
    }

    @Override
    public void minecolonies_tweaks$setColony(IColony colony) {
        this.minecolonies_tweaks$colony = colony;
    }
}

