/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.research;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.core.client.gui.WindowSelectRes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class ResearchCostSelector {
    private final BOWindow origin;
    private final IGlobalResearch research;
    private final List<SizedIngredient> costs;
    private final Consumer<List<ItemStorage>> consumer;
    private List<ItemStorage> selectedCosts;

    public static void open(BOWindow origin, IGlobalResearch research, Consumer<List<ItemStorage>> consumer) {
        new ResearchCostSelector(origin, research, consumer).open();
    }

    private ResearchCostSelector(BOWindow origin, IGlobalResearch research, Consumer<List<ItemStorage>> consumer) {
        this.origin = origin;
        this.research = research;
        this.costs = this.research.getCostList();
        this.consumer = consumer;
    }

    public void open() {
        this.selectedCosts = new ArrayList<ItemStorage>();
        this.cycle();
    }

    private void cycle() {
        int costsCount = this.costs.size();
        while (this.selectedCosts.size() < costsCount) {
            SizedIngredient cost = this.costs.get(this.selectedCosts.size());
            List<Item> items = Arrays.stream(cost.getItems()).map(ItemStack::getItem).toList();
            if (items.size() > 1) {
                new WindowSelectRes(this.origin, stack -> items.contains(stack.getItem()), (stack, count) -> {
                    this.selectedCosts.add(new ItemStorage(stack, cost.count()));
                    this.cycle();
                }, false).open();
                break;
            }
            this.selectedCosts.add(new ItemStorage(items.get(0), cost.count()));
        }
        if (this.selectedCosts.size() == costsCount) {
            this.consumer.accept(new ArrayList<ItemStorage>(this.selectedCosts));
        }
    }
}

