/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class ResearchCost
implements IRequestableObject {
    public static final ResourceLocation ID = MineColoniesTweaks.rl("research_cost");
    public static final Component DISPLAY_STRING = Component.translatable((String)"minecolonies_tweaks.text.research_cost");
    public static final ResourceLocation ICON = ResourceLocation.parse((String)"textures/item/book.png");
    private final ResourceLocation branchId;
    private final ResourceLocation researchId;
    private final List<ItemStorage> items;
    private final UUID requester;
    private final Component longText;
    private final List<MutableComponent> tooltip;

    public static ResearchCost deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        ResourceLocation branch = ResourceLocation.parse((String)compound.getString("branch"));
        ResourceLocation research = ResourceLocation.parse((String)compound.getString("research"));
        List<ItemStorage> items = NBTUtils.streamCompound((ListTag)compound.getList("stacks", 10)).map(SerializationHelper.deserializerTag(provider)).toList();
        UUID requester = compound.hasUUID("requester") ? compound.getUUID("requester") : null;
        return new ResearchCost(branch, research, items, requester);
    }

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound, ResearchCost cost) {
        compound.putString("branch", cost.branchId.toString());
        compound.putString("research", cost.researchId.toString());
        compound.put("items", (Tag)cost.items.stream().map(SerializationHelper.serializerTag(provider)).collect(NBTUtils.toListNBT()));
        if (cost.requester != null) {
            compound.putUUID("requester", cost.requester);
        }
    }

    public static boolean test(IRequest<?> request, ResourceLocation branch, ResourceLocation research) {
        ResearchCost other;
        CustomizableRequestable cr;
        Object object = request.getRequest();
        return object instanceof CustomizableRequestable && (object = (cr = (CustomizableRequestable)object).getObject()) instanceof ResearchCost && (other = (ResearchCost)object).getBranchId().equals((Object)branch) && other.getResearchId().equals((Object)research);
    }

    public static boolean isRequested(IBuilding building, ResourceLocation branch, ResourceLocation research) {
        for (IToken token : (Collection)building.getOpenRequestsByRequestableType().getOrDefault(CustomizableRequestable.TYPE_TOKEN, Collections.emptyList())) {
            IRequest request = building.getColony().getRequestManager().getRequestForToken(token);
            if (!ResearchCost.test(request, branch, research)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRequested(IBuildingView buildingView, ResourceLocation branch, ResourceLocation research) {
        for (IRequest request : buildingView.getOpenRequestsOfBuilding()) {
            if (!ResearchCost.test(request, branch, research)) continue;
            return true;
        }
        return false;
    }

    public ResearchCost(ResourceLocation branchId, ResourceLocation researchId, List<ItemStorage> items, UUID requester) {
        this.branchId = branchId;
        this.researchId = researchId;
        this.items = ImmutableList.copyOf(items);
        this.requester = requester;
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearchBranch branch = researchTree.getBranchData(branchId);
        MutableComponent branchText = Component.literal((String)branchId.toString());
        MutableComponent researchText = Component.literal((String)researchId.toString());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.empty().append(DISPLAY_STRING));
        if (branch == null) {
            tooltip.add(Component.translatable((String)"minecolonies_tweaks.gui.branch_missing").withStyle(ChatFormatting.RED));
            tooltip.add(Component.translatable((String)"minecolonies_tweaks.text.research_cost.branch", (Object[])new Object[]{Component.literal((String)branchId.toString()).withStyle(ChatFormatting.RED)}));
            tooltip.add(Component.translatable((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{Component.literal((String)researchId.toString()).withStyle(ChatFormatting.RED)}));
        } else {
            IGlobalResearch research = researchTree.getResearch(branchId, researchId);
            branchText = MutableComponent.create((ComponentContents)branch.getName());
            tooltip.add(Component.translatable((String)"minecolonies_tweaks.text.research_cost.branch", (Object[])new Object[]{branchText}));
            if (research == null) {
                tooltip.add(Component.translatable((String)"minecolonies_tweaks.gui.research_missing").withStyle(ChatFormatting.RED));
                tooltip.add(Component.translatable((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{Component.literal((String)researchId.toString()).withStyle(ChatFormatting.RED)}));
            } else {
                researchText = MutableComponent.create((ComponentContents)research.getName());
                tooltip.add(Component.translatable((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{researchText}));
            }
        }
        this.longText = Component.translatable((String)"minecolonies_tweaks.text.research_cost.long", (Object[])new Object[]{branchText, researchText});
        this.tooltip = tooltip;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @NotNull
    public Component getShortDisplayString() {
        return DISPLAY_STRING;
    }

    @Override
    @NotNull
    public Component getLongDisplayString() {
        return this.longText;
    }

    @Override
    @NotNull
    public List<ItemStack> getDisplayStacks() {
        return Collections.emptyList();
    }

    @Override
    public ResourceLocation getDisplayIcon() {
        return ICON;
    }

    @Override
    @NotNull
    public List<MutableComponent> getResolverToolTip(@NotNull IColonyView colony) {
        return this.tooltip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ResearchCost)) return false;
        ResearchCost other = (ResearchCost)obj;
        if (!other.branchId.equals((Object)this.branchId)) return false;
        if (!other.researchId.equals((Object)this.researchId)) return false;
        return true;
    }

    public ResourceLocation getBranchId() {
        return this.branchId;
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    public List<ItemStorage> getItems() {
        return this.items;
    }

    public UUID getRequester() {
        return this.requester;
    }
}

