/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCost;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostResolver;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class ResearchCostRequestMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<ResearchCostRequestMessage> TYPE = new CustomPacketPayload.Type(MineColoniesTweaks.rl("research_cost_request"));
    private final BuildingPos buildingPos;
    private final ResourceLocation branch;
    private final ResourceLocation research;
    private final List<ItemStorage> items;

    public ResearchCostRequestMessage(BuildingPos buildingPos, ResourceLocation branch, ResourceLocation research, List<ItemStorage> items) {
        this.buildingPos = buildingPos;
        this.branch = branch;
        this.research = research;
        this.items = new ArrayList<ItemStorage>(items);
    }

    public ResearchCostRequestMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.buildingPos = new BuildingPos((FriendlyByteBuf)buffer);
        this.branch = buffer.readResourceLocation();
        this.research = buffer.readResourceLocation();
        this.items = buffer.readList(SerializationHelper::deserialize);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        this.buildingPos.serializeBuffer((FriendlyByteBuf)buffer);
        buffer.writeResourceLocation(this.branch);
        buffer.writeResourceLocation(this.research);
        buffer.writeCollection(this.items, SerializationHelper::serialize);
    }

    @Override
    public void handle(IPayloadContext context) {
        IGlobalResearch research;
        super.handle(context);
        Player player = context.player();
        IBuilding building = this.buildingPos.getBuilding();
        if (!ResearchCostResolver.hasResolver(building)) {
            player.sendSystemMessage((Component)Component.literal((String)"Resolver not exist").withStyle(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        if (ResearchCost.isRequested(building, this.branch, this.research)) {
            player.sendSystemMessage((Component)Component.translatable((String)"minecolonies_tweaks.gui.already_requested").withStyle(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        IGlobalResearchTree tree = IGlobalResearchTree.getInstance();
        IGlobalResearchBranch branch = tree.getBranchData(this.branch);
        IGlobalResearch iGlobalResearch = research = branch != null ? tree.getResearch(this.branch, this.research) : null;
        if (research == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"minecolonies_tweaks.gui.research_not_found", (Object[])new Object[]{this.branch, this.research}).withStyle(ChatFormatting.GRAY));
            SoundUtils.playErrorSound((Player)player, (BlockPos)building.getPosition());
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"minecolonies_tweaks.gui.research_cost_requested", (Object[])new Object[]{MutableComponent.create((ComponentContents)branch.getName()), MutableComponent.create((ComponentContents)research.getName())}).withStyle(ChatFormatting.GRAY));
        ResearchCost request = new ResearchCost(this.branch, this.research, this.items, player.getUUID());
        building.createRequest((IRequestable)new CustomizableRequestable(request), true);
        SoundUtils.playSuccessSound((Player)player, (BlockPos)building.getPosition());
    }

    public CustomPacketPayload.Type<ResearchCostRequestMessage> type() {
        return TYPE;
    }

    public BuildingPos getBuildingPos() {
        return this.buildingPos;
    }

    public ResourceLocation getBranch() {
        return this.branch;
    }

    public ResourceLocation getResearch() {
        return this.research;
    }

    public List<ItemStorage> getItems() {
        return this.items;
    }
}

