/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksDataComponents;

public abstract class ItemBuildingLinkScroll
extends Item {
    public static final Component TOOLIP_HOW_TO_LINK = Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.how_to_link");
    public static final Component MESSAGE_MISSING_POS = Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.missing_pos");
    public static final Component MESSAGE_MISSING_BUILDING = Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.missing_building");
    public static final Component TEXT_BUILDING_MISSING = Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.building_missing").withStyle(ChatFormatting.GRAY);
    public static final Component TEXT_LINKED = Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.linked");

    public ItemBuildingLinkScroll(Item.Properties properites) {
        super(properites.stacksTo(1));
    }

    @Nullable
    public static void setPos(@NotNull ItemStack stack, @Nullable BuildingPos pos) {
        stack.set(MCTweaksDataComponents.BUILDING_POS, (Object)pos);
    }

    @Nullable
    public static BuildingPos getPos(@NotNull ItemStack stack) {
        return (BuildingPos)stack.get(MCTweaksDataComponents.BUILDING_POS);
    }

    protected abstract void openWindow(@NotNull ItemStack var1, @Nullable Player var2, @Nullable IBuildingView var3);

    public abstract boolean testForLink(@NotNull IBuilding var1);

    public void openWindow(@NotNull ItemStack stack, @Nullable Player player) {
        BuildingPos pos = ItemBuildingLinkScroll.getPos(stack);
        if (pos == null) {
            if (player != null) {
                player.sendSystemMessage(MESSAGE_MISSING_POS);
            }
            return;
        }
        IBuildingView buildingView = pos.getBuildingView();
        if (buildingView == null) {
            if (player != null) {
                player.sendSystemMessage(MESSAGE_MISSING_BUILDING);
            }
            return;
        }
        this.openWindow(stack, player, buildingView);
    }

    public InteractionResult useOn(UseOnContext context) {
        AbstractTileEntityColonyBuilding buildingEntity;
        IBuilding building;
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        if (level.isClientSide()) {
            if (!(blockEntity instanceof AbstractTileEntityColonyBuilding)) {
                this.openWindow(stack, context.getPlayer());
            }
        } else if (blockEntity instanceof AbstractTileEntityColonyBuilding && (building = (buildingEntity = (AbstractTileEntityColonyBuilding)blockEntity).getBuilding()) != null && this.testForLink(building)) {
            ItemBuildingLinkScroll.setPos(stack, new BuildingPos(building));
            context.getPlayer().sendSystemMessage(TEXT_LINKED);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            this.openWindow(stack, player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add(TOOLIP_HOW_TO_LINK);
        BuildingPos pos = ItemBuildingLinkScroll.getPos(stack);
        if (pos == null) {
            return;
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.linked_pos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        IBuildingView buildingView = pos.getBuildingView();
        Object buildingName = null;
        buildingName = buildingView == null ? TEXT_BUILDING_MISSING : Component.empty().append((Component)BuildingUtils.getDisplayName(buildingView)).withStyle(ChatFormatting.DARK_PURPLE);
        tooltip.add((Component)Component.translatable((String)"item.minecolonies_tweaks.buildingscroll.linked_building", (Object[])new Object[]{buildingName}));
    }
}

