/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CompostDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        this.setSuccess(true);
        ServerLevel level = source.level();
        BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        BlockState state = level.getBlockState(pos);
        if (!this.growCrop(level, pos, state, stack) && !BoneMealItem.growCrop((ItemStack)stack, (Level)level, (BlockPos)pos)) {
            this.setSuccess(false);
        } else if (!level.isClientSide) {
            level.levelEvent(1505, pos, 15);
        }
        return stack;
    }

    public boolean growCrop(ServerLevel level, BlockPos pos, BlockState state, ItemStack stack) {
        MinecoloniesCropBlock crop;
        Block block = state.getBlock();
        if (block instanceof MinecoloniesCropBlock && !(crop = (MinecoloniesCropBlock)block).isMaxAge(state)) {
            stack.shrink(1);
            crop.attemptGrow(state, level, pos);
            return true;
        }
        return false;
    }
}

