/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.init;

import com.minecolonies.core.items.ItemResourceScroll;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import steve_gall.minecolonies_tweaks.core.common.item.ItemCopyScroll;
import steve_gall.minecolonies_tweaks.core.common.item.ItemInventoryScroll;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;
import steve_gall.minecolonies_tweaks.core.common.item.ItemUniversityScroll;

public class MCTweaksItems {
    public static final DeferredRegister<Item> REGISTER = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"minecolonies_tweaks");
    public static final Map<DyeColor, DeferredHolder<Item, ItemResourceScroll>> COLOR_RESOURCE_SCROLLS;
    public static final DeferredHolder<Item, ItemResourceScrollBook> RESOURCESCROLL_BOOK;
    public static final DeferredHolder<Item, ItemInventoryScroll> INVENTORYSCROLL;
    public static final Map<DyeColor, DeferredHolder<Item, ItemInventoryScroll>> COLOR_INVENTORY_SCROLLS;
    public static final DeferredHolder<Item, ItemUniversityScroll> UNIVERSITYSCROLL;
    public static final DeferredHolder<Item, ItemCopyScroll> COPYSCROLL;

    private MCTweaksItems() {
    }

    static {
        RESOURCESCROLL_BOOK = REGISTER.register("resourcescroll_book", () -> new ItemResourceScrollBook(new Item.Properties(), 27));
        INVENTORYSCROLL = REGISTER.register("inventoryscroll", () -> new ItemInventoryScroll(new Item.Properties()));
        UNIVERSITYSCROLL = REGISTER.register("universityscroll", () -> new ItemUniversityScroll(new Item.Properties()));
        COPYSCROLL = REGISTER.register("copyscroll", () -> new ItemCopyScroll(new Item.Properties()));
        HashMap<DyeColor, DeferredHolder> colorResourceScrolls = new HashMap<DyeColor, DeferredHolder>();
        COLOR_RESOURCE_SCROLLS = Collections.unmodifiableMap(colorResourceScrolls);
        HashMap<DyeColor, DeferredHolder> colorWarehouseScrolls = new HashMap<DyeColor, DeferredHolder>();
        COLOR_INVENTORY_SCROLLS = Collections.unmodifiableMap(colorWarehouseScrolls);
        for (DyeColor color : DyeColor.values()) {
            DeferredHolder resourceScroll = REGISTER.register("resourcescroll_" + color.getName().toLowerCase(), () -> new ItemResourceScroll(new Item.Properties()));
            colorResourceScrolls.put(color, resourceScroll);
            DeferredHolder warehouseScroll = REGISTER.register("inventoryscroll_" + color.getName().toLowerCase(), () -> new ItemInventoryScroll(new Item.Properties()));
            colorWarehouseScrolls.put(color, warehouseScroll);
        }
    }
}

