/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import steve_gall.minecolonies_tweaks.core.common.config.ConfigConstants;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAICraftingAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAIStructureAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkFarmerAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkSifterAccessor;

public class JobConfig {
    public final ModConfigSpec.IntValue blockMiningDelay;
    public final ModConfigSpec.IntValue blockBuildingDelay;
    public final ModConfigSpec.IntValue menuPerLevel;
    public final ModConfigSpec.BooleanValue disableLeisure;
    public final ModConfigSpec.IntValue craftingProgressMultiplier;
    public final ModConfigSpec.IntValue craftingHittingTime;
    public final ModConfigSpec.IntValue craftingDecideDelay;
    public final ModConfigSpec.IntValue sifterProgressMultiplier;
    public final ModConfigSpec.BooleanValue dyerDisableBleaching;
    public final ModConfigSpec.IntValue farmerWorkDelay;
    public final ModConfigSpec.DoubleValue farmerSkillDivider;
    public final ModConfigSpec.IntValue farmerActionsDoneUntilDumping;
    public final ModConfigSpec.BooleanValue farmerPlantAfterHoe;
    public final ModConfigSpec.BooleanValue farmerPlantAfterHarvest;
    public final ModConfigSpec.BooleanValue structureLeavesFree;
    public final ModConfigSpec.IntValue warehouseCouriersPerLevel;
    public final ModConfigSpec.IntValue maximumStockKindsPerLevel;
    public final ModConfigSpec.DoubleValue undertakerResurrectTotemSingleChance;
    public final ModConfigSpec.DoubleValue undertakerResurrectTotemMultipleChance;
    public final ModConfigSpec.DoubleValue undertakerResurrectBuildingLevelWeight;
    public final ModConfigSpec.DoubleValue undertakerResurrectManaLevelWeight;
    public final ModConfigSpec.BooleanValue undertakerResurrectCapDisable;
    public final ModConfigSpec.DoubleValue undertakerResurrectCapBase;
    public final ModConfigSpec.DoubleValue undertakerResurrectCapMysticalLevelWeight;
    public final ModConfigSpec.DoubleValue undertakerResurrectTotemBreakChance;

    public JobConfig(ModConfigSpec.Builder builder) {
        this.blockMiningDelay = builder.defineInRange("blockMiningDelay", 500, 0, Integer.MAX_VALUE);
        this.blockBuildingDelay = builder.defineInRange("blockBuildingDelay", AbstractEntityAIStructureAccessor.getBuildBlockDelay(), 0, Integer.MAX_VALUE);
        builder.comment("for restaurant, netherworker");
        this.menuPerLevel = builder.defineInRange("menuPerLevel", 5, 0, Integer.MAX_VALUE);
        builder.comment("Disables the citizen's leisure.");
        this.disableLeisure = builder.define("disableLeisure", true);
        builder.push("crafing");
        builder.comment("craftingTicks = progressMultiplier / craftSkillLevel * hittingTime");
        this.craftingProgressMultiplier = builder.defineInRange("progressMultiplier", AbstractEntityAICraftingAccessor.getProgressMultiplier(), 0, Integer.MAX_VALUE);
        this.craftingHittingTime = builder.defineInRange("hittingTime", AbstractEntityAICraftingAccessor.getHittingTime(), 0, Integer.MAX_VALUE);
        builder.comment(new String[]{"The delay ticks for go to work again after Citizen returned at hut", "This was 0 in 1.19.2"});
        builder.comment(ConfigConstants.VANILLA_IS(400));
        this.craftingDecideDelay = builder.defineInRange("decideDelay", 0, 0, 400);
        builder.pop();
        builder.push("sifter");
        builder.comment("siftingTicks = progressMultiplier - strengthLevel");
        this.sifterProgressMultiplier = builder.defineInRange("progressMultiplier", EntityAIWorkSifterAccessor.getMaxLevel(), 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("dyer");
        builder.comment("disables wool bleaching to avoid wool loop crafting. To take effect it requires using the command \"/mc colony requestsystem-reset-all\"");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.dyerDisableBleaching = builder.define("dyerDisableBleaching", true);
        builder.pop();
        builder.push("farmer");
        builder.comment("finalDelay = workDelay - (skillDivider * staminaLevel)");
        this.farmerWorkDelay = builder.defineInRange("workDelay", EntityAIWorkFarmerAccessor.getStandardDelay(), 0, Integer.MAX_VALUE);
        this.farmerSkillDivider = builder.defineInRange("skillDivider", 2.0, 0.0, 2.147483647E9);
        builder.comment("if harvested count reached to this, farmer will go to dump");
        this.farmerActionsDoneUntilDumping = builder.defineInRange("actionsDoneUntilDumping", 256, EntityAIWorkFarmerAccessor.getMaxBlocksMined(), Integer.MAX_VALUE);
        builder.comment("whether plant seed after hoeing dirt");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.farmerPlantAfterHoe = builder.define("plantAfterHoe", true);
        builder.comment("whether plant seed after harvest crop");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.farmerPlantAfterHarvest = builder.define("plantAfterHarvest", true);
        builder.pop();
        builder.push("undertaker");
        builder.push("resurrectChance");
        builder.comment("resurrectChance = totemChance + (buiding's level * buildingLevelWeight) + (worker's mana * manaLevelWeight)");
        this.undertakerResurrectTotemSingleChance = builder.defineInRange("totemSingleChance", 0.05, 0.0, 1.0);
        this.undertakerResurrectTotemMultipleChance = builder.defineInRange("totemMultipleChance", 0.075, 0.0, 1.0);
        this.undertakerResurrectBuildingLevelWeight = builder.defineInRange("buildingLevelWeight", 0.005, 0.0, 1.0);
        this.undertakerResurrectManaLevelWeight = builder.defineInRange("manaLevelWeight", 0.00125, 0.0, 1.0);
        builder.pop();
        builder.push("resurrectChanceCap");
        builder.comment("resurrectChanceCap = totemChance + base + (Mystical Site's level * mysticalLevelWeight)");
        this.undertakerResurrectCapDisable = builder.define("disable", true);
        this.undertakerResurrectCapBase = builder.defineInRange("base", 0.025, 0.0, 1.0);
        this.undertakerResurrectCapMysticalLevelWeight = builder.defineInRange("mysticalLevelWeight", 0.005, 0.0, 1.0);
        builder.pop();
        this.undertakerResurrectTotemBreakChance = builder.defineInRange("resurrectTotemBreakChance", 0.01, 0.0, 1.0);
        builder.pop();
        builder.push("structure");
        builder.comment("If this is off, Builders will requests 'Leaves' on needed it when build.");
        this.structureLeavesFree = builder.define("leavesFree", true);
        builder.pop();
        builder.push("warehouse");
        this.warehouseCouriersPerLevel = builder.defineInRange("couriersPerLevel", 2, 1, 20);
        builder.pop();
        builder.push("maximumStock");
        builder.comment("This will be affected by research effect 'effects/minimumstockmultiplier'");
        this.maximumStockKindsPerLevel = builder.defineInRange("kindsPerLevel", 5, 0, 100);
        builder.pop();
    }
}

