/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.command;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import steve_gall.minecolonies_tweaks.core.common.research.LocalResearchTreeExtension;

public class ResearchCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.literal((String)"researches");
        command.then(ResearchCommands.reset());
        command.then(ResearchCommands.complete());
        return command;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reset() {
        return ResearchCommands.optionalBranch("reset", true, (context, colony, branchId) -> {
            IResearchManager localResearchManager = colony.getResearchManager();
            ILocalResearchTree patt0$temp = localResearchManager.getResearchTree();
            if (patt0$temp instanceof LocalResearchTreeExtension) {
                LocalResearchTreeExtension extension = (LocalResearchTreeExtension)patt0$temp;
                if (branchId == null) {
                    extension.minecolonies_tweaks$resetAll(colony);
                } else {
                    extension.minecolonies_tweaks$reset(colony, branchId);
                }
                localResearchManager.markDirty();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Done"), true);
                return 1;
            }
            IMinecoloniesAPI.getInstance().getGlobalResearchTree().getBranchData(null);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Fail"), true);
            return 0;
        });
    }

    private static LiteralArgumentBuilder<CommandSourceStack> complete() {
        return ResearchCommands.optionalBranch("complete", true, (context, colony, branchId) -> {
            IGlobalResearchTree globalResearchTree = IMinecoloniesAPI.getInstance().getGlobalResearchTree();
            IResearchManager localResearchManager = colony.getResearchManager();
            if (branchId == null) {
                for (ResourceLocation branch : globalResearchTree.getBranches()) {
                    ResearchCommands.complete(globalResearchTree, colony, branch, globalResearchTree.getPrimaryResearch(branch));
                }
            } else {
                ResearchCommands.complete(globalResearchTree, colony, branchId, globalResearchTree.getPrimaryResearch(branchId));
            }
            for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
                citizen.applyResearchEffects();
            }
            localResearchManager.markDirty();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Done"), true);
            return 1;
        });
    }

    private static void complete(IGlobalResearchTree globalResearchTree, IColony colony, ResourceLocation branchId, List<ResourceLocation> researchIds) {
        IGlobalResearchBranch globalBranchData = globalResearchTree.getBranchData(branchId);
        IResearchManager localResearchManager = colony.getResearchManager();
        ILocalResearchTree localResearchTree = localResearchManager.getResearchTree();
        for (ResourceLocation researchId : researchIds) {
            IGlobalResearch globalResearch = globalResearchTree.getResearch(branchId, researchId);
            globalResearch.startResearch(localResearchTree);
            ILocalResearch localResearch = localResearchTree.getResearch(branchId, researchId);
            if (localResearch.getState() == ResearchState.IN_PROGRESS) {
                localResearch.setProgress(globalBranchData.getBaseTime(globalResearch.getDepth()));
            }
            localResearch.research(localResearchManager.getResearchEffects(), localResearchTree);
            ResearchCommands.complete(globalResearchTree, colony, branchId, globalResearch.getChildren());
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> optionalBranch(String name, boolean needPermission, ResearchRunFunction func) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(((RequiredArgumentBuilder)IMCCommand.newArgument((String)"colonyID", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ResearchCommands.runOptionalBranch((CommandContext<CommandSourceStack>)context, needPermission, false, func))).then(ResearchCommands.newArgumentbranchID().executes(context -> ResearchCommands.runOptionalBranch((CommandContext<CommandSourceStack>)context, needPermission, true, func))));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> newArgumentbranchID() {
        return IMCCommand.newArgument((String)"branchID", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            for (ResourceLocation branchID : IMinecoloniesAPI.getInstance().getGlobalResearchTree().getBranches()) {
                builder.suggest(branchID.toString());
            }
            return builder.buildFuture();
        });
    }

    public static int runOptionalBranch(CommandContext<CommandSourceStack> context, boolean needPermission, boolean hasBranch, ResearchRunFunction func) {
        if (needPermission && !((CommandSourceStack)context.getSource()).hasPermission(2)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.notop"), true);
            return 0;
        }
        if (!((CommandSourceStack)context.getSource()).hasPermission(4)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, ((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (hasBranch) {
            ResourceLocation branchId = ResourceLocationArgument.getId(context, (String)"branchID");
            if (!IMinecoloniesAPI.getInstance().getGlobalResearchTree().getBranches().contains(branchId)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Research Branch Not Found: " + String.valueOf(branchId))), true);
                return 0;
            }
            return func.applyAsInt(context, colony, branchId);
        }
        return func.applyAsInt(context, colony, null);
    }

    public static interface ResearchRunFunction {
        public int applyAsInt(CommandContext<CommandSourceStack> var1, IColony var2, ResourceLocation var3);
    }
}

