/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building.module;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockEntry;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.IMaximumStockModuleView;
import steve_gall.minecolonies_tweaks.core.client.gui.MaximumStockModuleWindow;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigServer;
import steve_gall.minecolonies_tweaks.core.common.inventory.BlackHoleItemHandler;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import steve_gall.minecolonies_tweaks.core.common.network.message.MaximumStockUpdateMessage;

public class MaximumStockModule
extends AbstractBuildingModule
implements IMaximumStockModule,
IPersistentModule,
ITickingModule {
    protected final Object2IntMap<ItemStorage> maximumStock = new Object2IntOpenHashMap();

    @Override
    public int getMaximumStockCount() {
        return this.maximumStock.size();
    }

    @Override
    public int getMaximumStockLimit() {
        IBuilding building = this.building;
        double increase = 1.0 + building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
        return (int)((double)building.getBuildingLevel() * increase * (double)((Integer)MCTweaksConfigServer.INSTANCE.jobs.maximumStockKindsPerLevel.get()).intValue());
    }

    @Override
    public List<IMaximumStockEntry> getMaximumStocks() {
        ArrayList<IMaximumStockEntry> list = new ArrayList<IMaximumStockEntry>();
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            list.add(new Entry(((ItemStorage)entry.getKey()).getItemStack().copy(), entry.getIntValue()));
        }
        return list;
    }

    @Override
    public boolean isMaximumStocked(ItemStack stack) {
        return this.maximumStock.containsKey((Object)new ItemStorage(stack));
    }

    @Override
    public void addMaximumStock(ItemStack stack, int quantity) {
        if (stack.isEmpty()) {
            return;
        }
        this.maximumStock.put((Object)new ItemStorage(stack.copy()), quantity);
        this.markDirty();
    }

    @Override
    public void removeMaximumStock(ItemStack stack) {
        this.maximumStock.removeInt((Object)new ItemStorage(stack));
        this.markDirty();
    }

    public void onColonyTick(@NotNull IColony colony) {
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            ItemStack stack = ((ItemStorage)entry.getKey()).getItemStack();
            if (stack.isEmpty()) continue;
            int maxStackSize = stack.getMaxStackSize();
            int target = entry.getIntValue() * maxStackSize;
            Predicate<ItemStack> predicate = s -> this.matchesItem((ItemStack)s, stack);
            int count = InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate);
            int over = count - target;
            if (over <= 0) continue;
            InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((IItemHandlerCapProvider)this.building, predicate, (int)over, (IItemHandler)BlackHoleItemHandler.INSTANCE);
        }
    }

    public boolean matchesItem(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)stack1, (ItemStack)stack2, (boolean)false, (boolean)false);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        this.maximumStock.clear();
        ListTag maximumStackTag = compound.getList("maximumStock", 10);
        for (int i = 0; i < maximumStackTag.size(); ++i) {
            CompoundTag entryTag = maximumStackTag.getCompound(i);
            ItemStack stack = ItemSerializationHelper.deserializeTag(provider, entryTag.getCompound("key"));
            if (stack.isEmpty()) continue;
            ItemStorage key = new ItemStorage(stack);
            int value = entryTag.getInt("value");
            this.maximumStock.put((Object)key, value);
        }
    }

    public void serializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        ListTag maximumStackTag = new ListTag();
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("key", (Tag)ItemSerializationHelper.serializeTag(provider, ((ItemStorage)entry.getKey()).getItemStack()));
            entryTag.putInt("value", entry.getIntValue());
            maximumStackTag.add((Object)entryTag);
        }
        compound.put("maximumStock", (Tag)maximumStackTag);
    }

    public void serializeToView(RegistryFriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.maximumStock.size());
        for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
            ItemSerializationHelper.serialize((FriendlyByteBuf)buf, ((ItemStorage)entry.getKey()).getItemStack());
            buf.writeInt(entry.getIntValue());
        }
    }

    public record Entry(ItemStack stack, int quantity) implements IMaximumStockEntry
    {
    }

    public static class View
    extends AbstractBuildingModuleView
    implements IMaximumStockModuleView {
        public static final Component DESC = Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.maximumstock");
        protected final Object2IntMap<ItemStorage> maximumStock = new Object2IntOpenHashMap();

        public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
            this.maximumStock.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ItemStorage key = new ItemStorage(ItemSerializationHelper.deserialize((FriendlyByteBuf)buf));
                int value = buf.readInt();
                this.maximumStock.put((Object)key, value);
            }
        }

        @Override
        public List<IMaximumStockEntry> getMaximumStocks() {
            ArrayList<IMaximumStockEntry> list = new ArrayList<IMaximumStockEntry>();
            for (Object2IntMap.Entry entry : this.maximumStock.object2IntEntrySet()) {
                list.add(new Entry(((ItemStorage)entry.getKey()).getItemStack().copy(), entry.getIntValue()));
            }
            return list;
        }

        @Override
        public int getMaximumStockCount() {
            return this.maximumStock.size();
        }

        @Override
        public int getMaximumStockLimit() {
            IBuildingView building = this.buildingView;
            double increase = 1.0 + building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MINIMUM_STOCK);
            return (int)((double)building.getBuildingLevel() * increase * (double)((Integer)MCTweaksConfigServer.INSTANCE.jobs.maximumStockKindsPerLevel.get()).intValue());
        }

        @Override
        public boolean isMaximumStocked(ItemStack stack) {
            return this.maximumStock.containsKey((Object)new ItemStorage(stack));
        }

        @Override
        public void addMaximumStock(ItemStack stack, int quantity) {
            if (stack.isEmpty()) {
                return;
            }
            this.maximumStock.put((Object)new ItemStorage(stack.copy()), quantity);
            PacketDistributor.sendToServer((CustomPacketPayload)MaximumStockUpdateMessage.add(this, stack, quantity), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public void removeMaximumStock(ItemStack stack) {
            this.maximumStock.removeInt((Object)new ItemStorage(stack));
            PacketDistributor.sendToServer((CustomPacketPayload)MaximumStockUpdateMessage.remove(this, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public BOWindow getWindow() {
            return new MaximumStockModuleWindow(this);
        }

        public String getIcon() {
            return "maximumstock";
        }

        public Component getDesc() {
            return DESC;
        }
    }
}

