/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowResearchTree;
import com.minecolonies.core.client.gui.modules.building.UniversityModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.UniversityResearchModuleView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class UniversityDashboardWindow
extends AbstractWindowSkeleton {
    private final IBuildingView buildingView;
    private final UniversityModuleWindow fake;

    public UniversityDashboardWindow(UniversityResearchModuleView moduleView) {
        super(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"gui/layouthuts/layoutuniversity.xml"));
        this.buildingView = moduleView.getBuildingView();
        this.fake = new UniversityModuleWindow(moduleView){

            public void updateResearchCount(int offset) {
                UniversityDashboardWindow.this.updateResearchCount(offset);
            }

            public void open() {
                UniversityDashboardWindow.this.close();
                UniversityDashboardWindow.this.open();
            }
        };
        List branches = IGlobalResearchTree.getInstance().getBranches();
        branches.sort(Comparator.comparingInt(branchId -> IGlobalResearchTree.getInstance().getBranchData(branchId).getSortOrder()));
        ArrayList<ResourceLocation> visibleBranches = new ArrayList<ResourceLocation>();
        ArrayList<List<MutableComponent>> allRequirements = new ArrayList<List<MutableComponent>>();
        for (ResourceLocation branch : branches) {
            List<MutableComponent> requirements = this.getHidingRequirementDesc(branch);
            if (!requirements.isEmpty() && IGlobalResearchTree.getInstance().getBranchData(branch).getHidden()) continue;
            visibleBranches.add(branch);
            allRequirements.add(requirements);
        }
        ScrollingList researchList = (ScrollingList)this.findPaneOfTypeByID("researches", ScrollingList.class);
        researchList.setDataProvider((ScrollingList.DataProvider)new ResearchListProvider(visibleBranches, allRequirements));
        this.updateResearchCount(0);
    }

    public List<MutableComponent> getHidingRequirementDesc(ResourceLocation branch) {
        ArrayList<MutableComponent> branchRequirements = new ArrayList<MutableComponent>();
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        for (ResourceLocation primaryResearchId : researchTree.getPrimaryResearch(branch)) {
            IGlobalResearch research = researchTree.getResearch(branch, primaryResearchId);
            List researchRequirements = research.getResearchRequirements();
            if (!research.isHidden() || researchTree.isResearchRequirementsFulfilled(researchRequirements, (IColony)this.buildingView.getColony())) {
                return Collections.emptyList();
            }
            if (branchRequirements.isEmpty()) {
                branchRequirements.add(Component.translatable((String)"com.minecolonies.coremod.research.locked"));
            } else {
                branchRequirements.add(Component.translatable((String)"Or").setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
            }
            for (IResearchRequirement requirement : researchRequirements) {
                if (!requirement.isFulfilled((IColony)this.buildingView.getColony())) {
                    branchRequirements.add(Component.literal((String)"-").append((Component)requirement.getDesc().setStyle(Style.EMPTY.withColor(ChatFormatting.RED))));
                    continue;
                }
                branchRequirements.add(Component.literal((String)"-").append((Component)requirement.getDesc().setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA))));
            }
        }
        return branchRequirements;
    }

    public void onButtonClicked(Button button) {
        super.onButtonClicked(button);
        if (button.getParent() != null) {
            ResourceLocation branchName;
            ResourceLocation resourceLocation = branchName = button.getParent() == null ? null : ResourceLocation.tryParse((String)button.getParent().getID());
            if (branchName != null && IGlobalResearchTree.getInstance().getBranches().contains(branchName)) {
                new WindowResearchTree(branchName, this.buildingView, this.fake).open();
            }
        }
    }

    public void updateResearchCount(int offset) {
        int researchInProgress = this.buildingView.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() + offset;
        ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.gui.research.countinprogress", (Object[])new Object[]{researchInProgress, this.buildingView.getBuildingLevel()}));
        if (this.buildingView.getBuildingLevel() <= researchInProgress) {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"red", (int)0));
        } else {
            ((Text)this.findPaneOfTypeByID("maxresearchwarn", Text.class)).setColors(Color.getByName((String)"black", (int)0));
        }
    }

    private static class ResearchListProvider
    implements ScrollingList.DataProvider {
        private final List<ResourceLocation> branches;
        private final List<List<MutableComponent>> requirements;

        public ResearchListProvider(List<ResourceLocation> branches, List<List<MutableComponent>> requirements) {
            this.branches = branches;
            this.requirements = requirements;
        }

        public int getElementCount() {
            return this.branches.size();
        }

        public void updateElement(int index, Pane rowPane) {
            ResourceLocation branchId = this.branches.get(index);
            IGlobalResearchBranch branchData = IGlobalResearchTree.getInstance().getBranchData(branchId);
            List<MutableComponent> requirements = this.requirements.get(index);
            ButtonImage button = (ButtonImage)rowPane.findPaneOfTypeByID("name", ButtonImage.class);
            button.getParent().setID(branchId.toString());
            if (requirements.isEmpty()) {
                button.setText(MutableComponent.create((ComponentContents)branchData.getName()));
            } else {
                button.setText(Component.translatable((String)"----------"));
                button.disable();
            }
            if (!(button.getHoverPane() != null || requirements.isEmpty() && branchData.getSubtitle().getKey().isEmpty())) {
                AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane((Pane)button);
                if (!branchData.getSubtitle().getKey().isEmpty()) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append(MutableComponent.create((ComponentContents)branchData.getSubtitle()))).colorName("GRAY")).paragraphBreak();
                }
                if (!requirements.isEmpty()) {
                    for (MutableComponent requirement : requirements) {
                        ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverText.append(requirement)).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).paragraphBreak();
                    }
                }
                hoverText.build();
            }
        }
    }
}

