/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.ItemResourceScrollAccessor;

public class ResourceScrollElement
extends ResourceScrollBookElement {
    private Component workerName = EMPTY;
    private Component constructionName = EMPTY;
    private Component progress = EMPTY;

    public ResourceScrollElement(ItemStack stack) {
        super(stack);
    }

    @Override
    public void onOpenClicked() {
        super.onOpenClicked();
        Minecraft mc = Minecraft.getInstance();
        ItemResourceScrollAccessor.invokeOpenWindow(this.stack, (Player)mc.player);
    }

    @Override
    public void update() {
        super.update();
        BuildingBuilder.View buildingView = this.getBuildingView();
        if (buildingView == null) {
            this.workerName = EMPTY;
            this.constructionName = BUILDER_NOT_SETTED;
            this.progress = EMPTY;
            return;
        }
        this.valid = true;
        this.workerName = Component.translatable((String)"%s (lvl. %s)", (Object[])new Object[]{buildingView.getWorkerName(), buildingView.getBuildingLevel()}).withStyle(ChatFormatting.DARK_PURPLE);
        BuildingResourcesModuleView resourceView = (BuildingResourcesModuleView)buildingView.getModuleViewByType(BuildingResourcesModuleView.class);
        IWorkOrderView workOrderView = buildingView.getColony().getWorkOrder(resourceView.getWorkOrderId());
        this.constructionName = workOrderView != null ? Component.literal((String)workOrderView.getDisplayName().getString().replace("\n", " ")) : Component.empty();
        double supplied = 0.0;
        double total = 0.0;
        for (BuildingBuilderResource resource : resourceView.getResources().values()) {
            supplied += (double)Math.min(resource.getAvailable(), resource.getAmount());
            total += (double)resource.getAmount();
        }
        this.progress = total > 0.0 ? Component.translatable((String)"com.minecolonies.coremod.gui.progress.res", (Object[])new Object[]{(int)(supplied / total * 100.0) + "%", resourceView.getProgress() + "%"}) : EMPTY;
    }

    @Override
    public void update(int index, Pane rowPane) {
        super.update(index, rowPane);
        this.getDesc1Label(rowPane).setText(this.workerName);
        this.getDesc2Label(rowPane).setText(this.constructionName);
        this.getDesc3Label(rowPane).setText(this.progress);
        this.getTooltip2(rowPane).setText(this.constructionName);
    }

    public BuildingBuilder.View getBuildingView() {
        IBuildingView iBuildingView = BuildingId.readBuildingViewFromItemStack((ItemStack)this.stack);
        if (iBuildingView instanceof BuildingBuilder.View) {
            BuildingBuilder.View buildingView = (BuildingBuilder.View)iBuildingView;
            return buildingView;
        }
        return null;
    }
}

