/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElementEvent;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksTags;

public class ResourceScrollBookListWindow
extends AbstractWindowSkeleton {
    public static final Component EMPTY = Component.empty();
    public static final Component BUILDER_NOT_SETTED = Component.translatable((String)"minecolonies_tweaks.gui.resourcebook.builder_not_setted");
    public static final Component COLONY_NOT_SETTED = Component.translatable((String)"minecolonies_tweaks.gui.resourcebook.colony_not_setted");
    public static final String BUTTON_OPEN = "open";
    public static final String LABEL_DESC1 = "desc1";
    public static final String LABEL_DESC2 = "desc2";
    private final List<ResourceScrollBookElement> elements = new ArrayList<ResourceScrollBookElement>();
    private final ScrollingList resourceList;

    public ResourceScrollBookListWindow(@Nullable BOWindow parent, List<ItemStack> stacks) {
        super(null, MineColoniesTweaks.rl("gui/resourcescroll_book_list_window.xml"));
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || !stack.is(MCTweaksTags.Items.RESOURCESCROLLBOOK_ELEMENT)) continue;
            NeoForge.EVENT_BUS.post((Event)new ResourceScrollBookElementEvent(stack, this.elements::add));
        }
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public void updateElement(int index, Pane rowPane) {
                ResourceScrollBookListWindow.this.elements.get(index).update(index, rowPane);
            }

            public int getElementCount() {
                return ResourceScrollBookListWindow.this.elements.size();
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        for (ResourceScrollBookElement element : this.elements) {
            element.update();
        }
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (button.getID().equals(BUTTON_OPEN)) {
            int index = this.resourceList.getListElementIndexByPane((Pane)button);
            ResourceScrollBookElement element = this.elements.get(index);
            element.onOpenClicked();
        }
    }

    public boolean onKeyTyped(char ch, int key) {
        int index = -1;
        if (48 == key) {
            index = 8;
        } else if (49 <= key && key <= 57) {
            index = key - 49;
        }
        if (index > -1 && index < this.elements.size()) {
            this.elements.get(index).onOpenClicked();
        }
        return super.onKeyTyped(ch, key);
    }
}

