/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;
import steve_gall.minecolonies_tweaks.core.common.colony.BatchUpgradeData;
import steve_gall.minecolonies_tweaks.core.common.network.message.BatchUpgradeDataLoadMessage;
import steve_gall.minecolonies_tweaks.core.common.network.message.BatchUpgradeDataSaveMessage;

public class BatchUpgradeBuildingsWindow
extends AbstractWindowSkeleton {
    public static final String LIST_BUILDINGS = "buildings";
    public static final String LIST_BUILDERS = "builders";
    public static final String LIST_UPGRADE_RESOURCES = "upgradeResources";
    public static final String ICON_BUILDING = "buildingIcon";
    public static final String TEXT_BUILDING_NAME = "buildingName";
    public static final String TEXT_BUILDER_NAME = "builderName";
    public static final String TEXT_ASSIGNED_COUNT = "assignedCount";
    public static final String TEXT_DISTANCE_WITH_BUILDING = "distanceWithBuilding";
    public static final String BUTTON_ASSIGN_AUTO = "assignAllAutomatically";
    public static final String BUTTON_ASSGIN_CLEAR = "clearAssignments";
    public static final String BUTTON_MARK_ALL = "markAllDontUpgrade";
    public static final String BUTTON_MARK_CLAR = "clearDontUpgrade";
    public static final String TEXT_SELECTION = "selectionText";
    private final IColonyView colony;
    private final BOWindow parent;
    private final TextField nameField;
    private final ScrollingList buildingList;
    private final ScrollingList builderList;
    private final ScrollingList upgradeResourceList;
    private final Text selectionText;
    private final Set<BlockPos> savedDontUpgrades;
    private final List<BuildingInfo> updatingBuildings;
    private final Map<BlockPos, BuildingInfo> buildings;
    private final List<BuildingInfo> filteredBuildings;
    private final List<BuilderInfo> builders;
    private final List<BuilderInfo> filteredBuilders;
    private final List<ItemStorage> upgradeResources;
    private final Map<BuildingInfo, BuilderInfo> assignments;
    private boolean requested = false;
    private boolean updating = false;
    private int updateProgress = 0;
    private int updateCount = 0;
    private int selectedBuildingIndex = -1;
    private int selectedBuilderIndex = -1;
    private int lastBuildersBuildingIndex = -1;
    private int lastResourcesBuildingIndex = -1;
    private int nameFilterRequested = 0;

    public BatchUpgradeBuildingsWindow(@Nullable BOWindow parent, IColonyView colony) {
        super(null, MineColoniesTweaks.rl("gui/batch_upgrade_buildings_window.xml"));
        this.colony = colony;
        this.parent = parent;
        this.nameField = (TextField)this.window.findPaneOfTypeByID("input", TextField.class);
        this.buildingList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_BUILDINGS, ScrollingList.class);
        this.builderList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_BUILDERS, ScrollingList.class);
        this.upgradeResourceList = (ScrollingList)this.window.findPaneOfTypeByID(LIST_UPGRADE_RESOURCES, ScrollingList.class);
        this.selectionText = (Text)this.window.findPaneOfTypeByID(TEXT_SELECTION, Text.class);
        this.savedDontUpgrades = new HashSet<BlockPos>();
        this.updatingBuildings = new ArrayList<BuildingInfo>();
        this.buildings = new HashMap<BlockPos, BuildingInfo>();
        this.filteredBuildings = new ArrayList<BuildingInfo>();
        this.builders = new ArrayList<BuilderInfo>();
        this.filteredBuilders = new ArrayList<BuilderInfo>();
        this.upgradeResources = new ArrayList<ItemStorage>();
        this.assignments = new HashMap<BuildingInfo, BuilderInfo>();
        this.nameField.setHandler(this::onFieldInput);
        this.buildingList.setDataProvider(this.filteredBuildings::size, this::updateBuildingRow);
        this.builderList.setDataProvider(this.filteredBuilders::size, this::updateBuilderRow);
        this.upgradeResourceList.setDataProvider(this.upgradeResources::size, this::updateUpgradeResourceRow);
    }

    public void setSavedBuildings(BatchUpgradeData data) {
        this.savedDontUpgrades.clear();
        for (BlockPos blockPos : data.getMarkAsDontUpgrades()) {
            this.savedDontUpgrades.add(blockPos);
        }
        if (!this.updating) {
            for (BuildingInfo buildingInfo : this.buildings.values()) {
                this.applySavedData(buildingInfo);
            }
            this.updateBuildingList();
            this.onBuildingCountsChanged();
        }
    }

    private void applySavedData(BuildingInfo building) {
        BlockPos id = building.building.getID();
        if (this.savedDontUpgrades.contains(id)) {
            this.savedDontUpgrades.remove(id);
            this.markAsDontUpgrade(building);
        }
    }

    public void close() {
        if (this.parent != null) {
            this.parent.open();
            return;
        }
        super.close();
    }

    protected void onFieldInput(TextField input) {
        if (input == this.nameField) {
            this.nameFilterRequested = 10;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.requested = true;
        this.nameField.setFocus();
        this.updateBuildingList();
        this.onBuildingCountsChanged();
        PacketDistributor.sendToServer((CustomPacketPayload)new BatchUpgradeDataLoadMessage(this.colony), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate() {
        super.onUpdate();
        if (this.updating) {
            List<BuildingInfo> list = this.updatingBuildings;
            synchronized (list) {
                if (this.updateProgress >= this.updateCount) {
                    this.updating = false;
                }
                for (BuildingInfo building : this.updatingBuildings) {
                    this.buildings.put(building.building.getID(), building);
                    this.applySavedData(building);
                }
                this.updatingBuildings.clear();
            }
            this.nameFilterRequested = 0;
            this.updateBuildingList();
            this.onBuildingCountsChanged();
        }
        if (this.requested && !this.updating) {
            this.requested = false;
            this.updating = true;
            this.updateProgress = 0;
            this.updateCount = 0;
            this.buildings.clear();
            this.builders.clear();
            for (ICitizenDataView citizen : this.colony.getCitizens().values()) {
                IJobView jobView = citizen.getJobView();
                if (jobView == null || jobView.getEntry() != ModJobs.builder.get()) continue;
                this.builders.add(new BuilderInfo(this.colony, citizen));
            }
            ClientLevel level = this.mc.level;
            for (BuildingInfo building : this.colony.getBuildings()) {
                Object buildingName;
                if (building.hasWorkOrder() || building.isBuildingMaxLevel() || !BuildingUtils.isUnlocked((IColony)this.colony, building.getBuildingType(), building.getBuildingLevel() + 1) || ((String)(buildingName = building.getStructurePath().replace(".blueprint", ""))).isEmpty()) continue;
                ++this.updateCount;
                buildingName = ((String)buildingName).substring(0, ((String)buildingName).length() - 1) + (building.getBuildingLevel() + 1) + ".blueprint";
                ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)building.getStructurePack(), (String)buildingName, (HolderLookup.Provider)level.registryAccess()), arg_0 -> this.lambda$onUpdate$3((IBuildingView)building, level, arg_0)));
            }
        }
        if (this.nameFilterRequested > 0 && --this.nameFilterRequested == 0) {
            this.updateBuildingList();
        }
        this.updateBuilderList();
        this.updateUpgradeResources();
    }

    public boolean click(double mx, double my) {
        boolean b = super.click(mx, my);
        if (b) {
            return b;
        }
        int buildingIndex = this.getHoveredRow(this.buildingList);
        if (buildingIndex > -1) {
            this.selectedBuildingIndex = buildingIndex;
            this.updateBuilderList();
            this.selectCurrentAssignedBuilder();
            return true;
        }
        int builderIndex = this.getHoveredRow(this.builderList);
        if (builderIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(this.selectedBuildingIndex);
            if (this.selectedBuilderIndex == builderIndex) {
                this.selectedBuilderIndex = -1;
                this.unassign(building);
            } else {
                this.selectedBuilderIndex = builderIndex;
                this.assign(building, this.filteredBuilders.get(builderIndex));
            }
            this.onBuildingCountsChanged();
            return true;
        }
        return false;
    }

    protected void selectCurrentAssignedBuilder() {
        if (this.selectedBuildingIndex == -1) {
            this.selectedBuilderIndex = -1;
            return;
        }
        BuildingInfo building = this.filteredBuildings.get(this.selectedBuildingIndex);
        BuilderInfo builder = this.assignments.get(building);
        this.selectedBuilderIndex = this.filteredBuilders.indexOf(builder);
    }

    protected int getHoveredRow(ScrollingList list) {
        List children = list.getContainer().getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Pane pane = (Pane)children.get(i);
            if (!(pane instanceof Box) || !pane.wasCursorInPane()) continue;
            return i;
        }
        return -1;
    }

    public boolean rightClick(double mx, double my) {
        boolean b = super.rightClick(mx, my);
        if (b) {
            return b;
        }
        int buildingIndex = this.getHoveredRow(this.buildingList);
        if (buildingIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(buildingIndex);
            if (building.dontUpgrade) {
                this.unmarkAsDontUpgrade(building);
            } else {
                this.markAsDontUpgrade(building);
            }
            this.selectedBuildingIndex = buildingIndex;
            this.onBuildingDontUpgradeChanged();
            return true;
        }
        return false;
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), BUTTON_ASSIGN_AUTO)) {
            this.filteredBuildings.forEach(this::unassign);
            Map<Integer, List<BuildingInfo>> groupsMap = this.filteredBuildings.stream().filter(building -> !building.dontUpgrade).collect(Collectors.groupingBy(building -> building.building.getBuildingLevel()));
            for (int buildingLevel = 5; buildingLevel > -1; --buildingLevel) {
                List<BuildingInfo> buildings = groupsMap.get(buildingLevel);
                if (buildings == null) continue;
                for (BuildingInfo building2 : buildings) {
                    List builders = this.streamWorkableBuilders(building2).collect(Collectors.toList());
                    if (builders.size() == 0) continue;
                    builders.sort((o1, o2) -> this.compareBuilderForAssign(building2, (BuilderInfo)o1, (BuilderInfo)o2));
                    BuilderInfo builder = (BuilderInfo)builders.get(0);
                    this.assign(building2, builder);
                }
            }
            this.onBuildingCountsChanged();
            this.selectCurrentAssignedBuilder();
        } else if (Objects.equals(button.getID(), BUTTON_ASSGIN_CLEAR)) {
            this.filteredBuildings.forEach(this::unassign);
            this.onBuildingCountsChanged();
            this.selectCurrentAssignedBuilder();
        } else if (Objects.equals(button.getID(), BUTTON_MARK_ALL)) {
            this.filteredBuildings.forEach(this::markAsDontUpgrade);
            this.onBuildingDontUpgradeChanged();
        } else if (Objects.equals(button.getID(), BUTTON_MARK_CLAR)) {
            this.filteredBuildings.forEach(this::unmarkAsDontUpgrade);
            this.onBuildingDontUpgradeChanged();
        } else if (Objects.equals(button.getID(), "upgrade")) {
            if (this.updating) {
                return;
            }
            for (Map.Entry<BuildingInfo, BuilderInfo> entry : this.assignments.entrySet()) {
                new BuildRequestMessage(entry.getKey().building, BuildRequestMessage.Mode.BUILD, entry.getValue().building.getPosition()).sendToServer();
            }
            BatchUpgradeData data = new BatchUpgradeData();
            for (BuildingInfo building3 : this.buildings.values()) {
                if (!building3.dontUpgrade) continue;
                this.savedDontUpgrades.add(building3.building.getID());
            }
            this.savedDontUpgrades.forEach(data.getMarkAsDontUpgrades()::add);
            PacketDistributor.sendToServer((CustomPacketPayload)new BatchUpgradeDataSaveMessage(this.colony, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.close();
        } else if (Objects.equals(button.getID(), "cancel")) {
            this.close();
        }
    }

    protected int compareBuilderForAssign(BuildingInfo building, BuilderInfo o1, BuilderInfo o2) {
        if (o1.cachedAssignedCount != o2.cachedAssignedCount) {
            return Integer.compare(o1.cachedAssignedCount, o2.cachedAssignedCount);
        }
        return Double.compare(o1.getDistance(building), o2.getDistance(building));
    }

    protected void onBuildingDontUpgradeChanged() {
        this.updateBuilderList();
        this.selectCurrentAssignedBuilder();
        this.onBuildingCountsChanged();
    }

    protected Stream<BuilderInfo> streamWorkableBuilders(BuildingInfo building) {
        return this.builders.stream().filter(builder -> this.testWorkable(building, (BuilderInfo)builder));
    }

    protected boolean testWorkable(BuildingInfo building, BuilderInfo builder) {
        int builderLevel = builder.building.getBuildingLevel();
        int buildingLevel = building.building.getBuildingLevel();
        if (building.building instanceof BuildingBuilder.View) {
            return builderLevel >= buildingLevel;
        }
        return builderLevel > buildingLevel;
    }

    protected void onBuildingCountsChanged() {
        if (this.updating) {
            this.selectionText.setText(Component.translatable((String)"minecolonies_tweaks.gui.updating"));
        } else {
            this.selectionText.setText(Component.translatable((String)"minecolonies_tweaks.gui.assigned_counts", (Object[])new Object[]{this.assignments.size(), this.buildings.values().stream().filter(this::testBuildingForCount).count()}));
        }
    }

    protected boolean testBuildingForCount(BuildingInfo info) {
        return !info.dontUpgrade;
    }

    protected void updateBuildingList() {
        this.selectedBuildingIndex = -1;
        this.selectedBuilderIndex = -1;
        this.filteredBuildings.clear();
        String field = this.nameField.getText().toLowerCase(Locale.ENGLISH);
        this.buildings.values().stream().filter(this::testBuildingForList).filter(i -> this.filterBuilding(field, (BuildingInfo)i)).forEach(this.filteredBuildings::add);
        this.filteredBuildings.sort(this::compareBuilding);
        this.buildingList.refreshElementPanes();
        this.updateBuilderList();
        this.updateUpgradeResources();
    }

    protected int compareBuilding(BuildingInfo building1, BuildingInfo building2) {
        boolean assigned2;
        boolean dontUpgrade1 = building1.dontUpgrade;
        boolean dontUpgrade2 = building2.dontUpgrade;
        if (dontUpgrade1 != dontUpgrade2) {
            return Boolean.compare(dontUpgrade1, dontUpgrade2);
        }
        BuilderInfo builder1 = this.assignments.get(building1);
        BuilderInfo builder2 = this.assignments.get(building2);
        boolean assigned1 = builder1 != null;
        boolean bl = assigned2 = builder2 != null;
        if (assigned1 != assigned2) {
            return Boolean.compare(assigned2, assigned1);
        }
        if (assigned1) {
            return builder1.nameLowerCase.compareTo(builder2.nameLowerCase);
        }
        return Integer.compare(building1.itemId, building2.itemId);
    }

    protected void updateBuildingRow(int index, Pane row) {
        BuildingInfo building = this.filteredBuildings.get(index);
        BuilderInfo builder = this.assignments.get(building);
        ItemIcon buildingIcon = (ItemIcon)row.findPaneOfTypeByID(ICON_BUILDING, ItemIcon.class);
        buildingIcon.setItem(building.icon);
        Text buildingLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDING_NAME, Text.class);
        buildingLabel.setText(Component.empty().append(building.name));
        buildingLabel.setColors(this.getBuildingLabelColor(building, index).getColor().intValue());
        Text builderLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDER_NAME, Text.class);
        List builderTooltip = null;
        MutableComponent builderText = null;
        builderText = building.dontUpgrade ? Component.translatable((String)"minecolonies_tweaks.gui.dont_upgrade").withStyle(ChatFormatting.GRAY) : Component.translatable((String)"minecolonies_tweaks.gui.assigned_builder_name", (Object[])new Object[]{builder != null ? Component.translatable((String)"minecolonies_tweaks.gui.builder_name_with_level", (Object[])new Object[]{builder.name, builder.building.getBuildingLevel()}) : Component.translatable((String)"minecolonies_tweaks.gui.builder_no_assigned").withStyle(ChatFormatting.RED)});
        builderLabel.setText(builderText);
        Pane pane = builderLabel.getHoverPane();
        if (pane instanceof Tooltip) {
            Tooltip tooltip = (Tooltip)pane;
            tooltip.setText(builderTooltip);
        }
    }

    protected ChatFormatting getBuildingLabelColor(BuildingInfo building, int index) {
        if (this.selectedBuildingIndex == index) {
            return ChatFormatting.GOLD;
        }
        if (building.dontUpgrade) {
            return ChatFormatting.GRAY;
        }
        return ChatFormatting.WHITE;
    }

    protected boolean testBuildingForList(BuildingInfo building) {
        return true;
    }

    protected boolean filterBuilding(String filter, BuildingInfo building) {
        if (filter.isEmpty()) {
            return true;
        }
        if (building.idLowerCase.contains(filter)) {
            return true;
        }
        if (building.nameLowerCase.contains(filter)) {
            return true;
        }
        BuilderInfo builder = this.assignments.get(building);
        return builder != null && builder.nameLowerCase.contains(filter);
    }

    protected void updateBuilderList() {
        int buildingIndex = this.selectedBuildingIndex;
        if (this.lastBuildersBuildingIndex == buildingIndex) {
            return;
        }
        this.lastBuildersBuildingIndex = buildingIndex;
        this.filteredBuilders.clear();
        if (buildingIndex > -1) {
            BuildingInfo building = this.filteredBuildings.get(buildingIndex);
            this.builders.stream().filter(builder -> this.testWorkable(building, (BuilderInfo)builder)).forEach(this.filteredBuilders::add);
            this.filteredBuilders.sort((o1, o2) -> this.compareBuilder(building, (BuilderInfo)o1, (BuilderInfo)o2));
        }
        this.builderList.refreshElementPanes();
    }

    protected int compareBuilder(BuildingInfo building, BuilderInfo builder1, BuilderInfo builder2) {
        BuilderInfo assigned = this.assignments.get(building);
        if (assigned == builder1) {
            return -1;
        }
        if (assigned == builder2) {
            return 1;
        }
        return Double.compare(builder1.getDistance(building), builder2.getDistance(building));
    }

    protected void updateBuilderRow(int index, Pane row) {
        BuilderInfo builder = this.filteredBuilders.get(index);
        BuildingInfo building = this.lastBuildersBuildingIndex == -1 ? null : this.filteredBuildings.get(this.lastBuildersBuildingIndex);
        Text builderLabel = (Text)row.findPaneOfTypeByID(TEXT_BUILDER_NAME, Text.class);
        builderLabel.setText(Component.translatable((String)"minecolonies_tweaks.gui.builder_name_with_level", (Object[])new Object[]{builder.name, builder.building.getBuildingLevel()}));
        builderLabel.setColors(this.getBuilderLabelColor(index).getColor().intValue());
        Text assignedCountLabel = (Text)row.findPaneOfTypeByID(TEXT_ASSIGNED_COUNT, Text.class);
        assignedCountLabel.setText(Component.translatable((String)"minecolonies_tweaks.gui.assigned_count_with_value", (Object[])new Object[]{builder.cachedAssignedCount}));
        Text distanceLabel = (Text)row.findPaneOfTypeByID(TEXT_DISTANCE_WITH_BUILDING, Text.class);
        distanceLabel.setText(Component.translatable((String)"minecolonies_tweaks.gui.distance_with_building", (Object[])new Object[]{(int)builder.getDistance(building)}));
    }

    protected void updateUpgradeResources() {
        int buildingIndex = this.selectedBuildingIndex;
        if (this.lastResourcesBuildingIndex == buildingIndex) {
            return;
        }
        this.lastResourcesBuildingIndex = buildingIndex;
        this.upgradeResources.clear();
        if (buildingIndex > -1) {
            this.upgradeResources.addAll(this.filteredBuildings.get((int)buildingIndex).upgradeResources);
            this.upgradeResources.sort(this::compareResource);
        }
        this.upgradeResourceList.refreshElementPanes();
        for (Pane pane : this.window.getChildren()) {
            if (!(pane instanceof Tooltip.AutomaticTooltip)) continue;
            Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
            tooltip.setTextOld(Arrays.asList(new Component[0]));
        }
    }

    protected int compareResource(ItemStorage stack1, ItemStorage stack2) {
        int id1 = Item.getId((Item)stack1.getItem());
        int id2 = Item.getId((Item)stack2.getItem());
        return Integer.compare(id1, id2);
    }

    protected void updateUpgradeResourceRow(int index, Pane row) {
        ItemStorage storage = this.upgradeResources.get(index);
        ItemStack stack = storage.getItemStack();
        stack.setCount(storage.getAmount());
        ItemIcon icon = (ItemIcon)row.findPaneOfTypeByID("resourceIcon", ItemIcon.class);
        icon.setItem(stack);
        Text label = (Text)row.findPaneOfTypeByID("resourceName", Text.class);
        label.setText(stack.getHoverName());
    }

    protected ChatFormatting getBuilderLabelColor(int index) {
        if (this.selectedBuilderIndex == index) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.WHITE;
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (key == 256) {
            this.selectedBuildingIndex = -1;
        }
        return super.onUnhandledKeyTyped(ch, key);
    }

    protected void assign(BuildingInfo building, BuilderInfo builder) {
        building.dontUpgrade = false;
        BuilderInfo prevBuilder = this.assignments.put(building, builder);
        if (prevBuilder != builder) {
            ++builder.cachedAssignedCount;
            if (prevBuilder != null) {
                --prevBuilder.cachedAssignedCount;
            }
        }
    }

    protected void unassign(BuildingInfo building) {
        BuilderInfo builder = this.assignments.remove(building);
        if (builder != null) {
            --builder.cachedAssignedCount;
        }
    }

    protected void markAsDontUpgrade(BuildingInfo building) {
        building.dontUpgrade = true;
        this.unassign(building);
    }

    protected void unmarkAsDontUpgrade(BuildingInfo building) {
        building.dontUpgrade = false;
    }

    public IColonyView getColony() {
        return this.colony;
    }

    public Map<BuildingInfo, BuilderInfo> getAssignments() {
        return new HashMap<BuildingInfo, BuilderInfo>(this.assignments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$onUpdate$3(IBuildingView building, ClientLevel level, Blueprint blueprint) {
        HashMap<ItemStorage, AtomicInteger> upgradeResources = new HashMap<ItemStorage, AtomicInteger>();
        if (blueprint != null) {
            StructurePhasePlacementResult result;
            blueprint.setRotationMirror(building.getRotationMirror(), (Level)level);
            StructurePlacer placer = new StructurePlacer((IStructureHandler)new LoadOnlyStructureHandler((Level)level, building.getPosition(), blueprint, RotationMirror.NONE, true));
            BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
            do {
                result = placer.executeStructureStep((Level)level, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment((info, pos, handler) -> false), true);
                progressPos = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    AtomicInteger existing = upgradeResources.computeIfAbsent(new ItemStorage(stack.copyWithCount(1)), s -> new AtomicInteger());
                    existing.addAndGet(stack.getCount());
                }
            } while (result != null && result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
        }
        BuildingInfo buildingInfo = new BuildingInfo(building, upgradeResources);
        List<BuildingInfo> list = this.updatingBuildings;
        synchronized (list) {
            ++this.updateProgress;
            if (upgradeResources.size() > 0) {
                this.updatingBuildings.add(buildingInfo);
            }
        }
    }

    public static class BuildingInfo {
        public final IBuildingView building;
        public final Component name;
        public final String idLowerCase;
        public final String nameLowerCase;
        public final ItemStack icon;
        public final int itemId;
        public final List<ItemStorage> upgradeResources;
        public boolean dontUpgrade = false;

        public BuildingInfo(IBuildingView building, Map<ItemStorage, AtomicInteger> upgradeResources) {
            this.building = building;
            BuildingEntry buildingEntry = building.getBuildingType();
            this.name = BuildingUtils.getDisplayName(building);
            this.idLowerCase = buildingEntry.getRegistryName().toString().toLowerCase(Locale.ENGLISH);
            this.nameLowerCase = this.name.getString().toLowerCase(Locale.ENGLISH);
            this.icon = new ItemStack((ItemLike)buildingEntry.getBuildingBlock());
            this.itemId = Item.getId((Item)this.icon.getItem());
            this.upgradeResources = upgradeResources.entrySet().stream().map(this::toItemStorage).toList();
        }

        private ItemStorage toItemStorage(Map.Entry<ItemStorage, AtomicInteger> entry) {
            ItemStorage stack = entry.getKey().copy();
            stack.setAmount(entry.getValue().get());
            return stack;
        }
    }

    public static class BuilderInfo {
        public final ICitizenDataView citizen;
        public final Component name;
        public final String nameLowerCase;
        public final IBuildingView building;
        public int cachedAssignedCount = 0;
        private final Object2DoubleMap<BuildingInfo> distances = new Object2DoubleOpenHashMap();

        public BuilderInfo(IColonyView colony, ICitizenDataView builder) {
            this.citizen = builder;
            this.name = Component.literal((String)builder.getName());
            this.nameLowerCase = builder.getName().toLowerCase(Locale.ENGLISH);
            this.building = colony.getBuilding(builder.getWorkBuilding());
        }

        public double getDistance(BuildingInfo building) {
            return this.distances.computeIfAbsent((Object)building, b -> {
                BlockPos pos1 = this.building.getPosition();
                BlockPos pos2 = b.building.getPosition();
                return Math.sqrt(pos1.distSqr((Vec3i)pos2));
            });
        }
    }
}

