/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.registries;

import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DeferredRegisterHelper {
    public static DeferredRegister<BuildingEntry> buildings(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"buildings"), (String)modid);
    }

    public static DeferredHolder<BuildingEntry, BuildingEntry> registerBuilding(DeferredRegister<BuildingEntry> register, String name, Consumer<BuildingEntry.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).location();
        return register.register(name, () -> {
            BuildingEntry.Builder builder = new BuildingEntry.Builder();
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createBuildingEntry();
        });
    }

    public static DeferredRegister<GuardType> guardTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"guardtypes"), (String)modid);
    }

    public static DeferredHolder<GuardType, GuardType> registerGuardType(DeferredRegister<GuardType> register, DeferredHolder<JobEntry, JobEntry> jobEntry, Consumer<GuardType.Builder> consumer) {
        return DeferredRegisterHelper.registerGuardType(register, jobEntry.getId().getPath(), jobEntry, consumer);
    }

    public static DeferredHolder<GuardType, GuardType> registerGuardType(DeferredRegister<GuardType> register, String name, DeferredHolder<JobEntry, JobEntry> jobEntry, Consumer<GuardType.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).location();
        return register.register(name, () -> {
            GuardType.Builder builder = new GuardType.Builder();
            builder.setJobTranslationKey(rl.getNamespace() + ".job." + name);
            builder.setButtonTranslationKey(rl.getNamespace() + ".gui.workerhuts." + name);
            builder.setJobEntry((Supplier)jobEntry);
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createGuardType();
        });
    }

    public static DeferredRegister<JobEntry> jobs(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"jobs"), (String)modid);
    }

    public static DeferredHolder<JobEntry, JobEntry> registerJobEntry(DeferredRegister<JobEntry> register, String name, Consumer<JobEntry.Builder> consumer) {
        ResourceLocation rl = register.createTagKey(name).location();
        return register.register(name, () -> {
            JobEntry.Builder builder = new JobEntry.Builder();
            builder.setRegistryName(rl);
            consumer.accept(builder);
            return builder.createJobEntry();
        });
    }

    public static Map<EventType, List<Tuple<SoundEvent, SoundEvent>>> registerJobSoundEvents(DeferredRegister<SoundEvent> register, String name) {
        String namespace = register.createTagKey(name).location().getNamespace();
        HashMap<EventType, List<Tuple<SoundEvent, SoundEvent>>> map = new HashMap<EventType, List<Tuple<SoundEvent, SoundEvent>>>();
        for (EventType event : EventType.values()) {
            ArrayList<Tuple> individualSounds = new ArrayList<Tuple>();
            for (int i = 1; i <= 4; ++i) {
                String prefix = "citizen." + name;
                String suffix = i + "." + event.getId();
                SoundEvent maleSoundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(prefix + ".male" + suffix)));
                SoundEvent femaleSoundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(prefix + ".female" + suffix)));
                register.register(maleSoundEvent.getLocation().getPath(), () -> maleSoundEvent);
                register.register(femaleSoundEvent.getLocation().getPath(), () -> femaleSoundEvent);
                individualSounds.add(new Tuple((Object)maleSoundEvent, (Object)femaleSoundEvent));
            }
            map.put(event, individualSounds);
        }
        return map;
    }

    public static DeferredRegister<CraftingType> craftingTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"craftingtypes"), (String)modid);
    }

    public static <T extends CraftingType> DeferredHolder<CraftingType, T> registerCraftingType(DeferredRegister<CraftingType> register, String name, Function<ResourceLocation, T> func) {
        ResourceLocation id = register.createTagKey(name).location();
        return register.register(name, () -> (CraftingType)func.apply(id));
    }

    public static DeferredRegister<RecipeTypeEntry> recipeTypeEntries(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"recipetypeentries"), (String)modid);
    }

    public static DeferredHolder<RecipeTypeEntry, RecipeTypeEntry> registerRecipeTypeEntry(DeferredRegister<RecipeTypeEntry> register, String name, BiConsumer<ResourceLocation, RecipeTypeEntry.Builder> consumer) {
        ResourceLocation id = register.createTagKey(name).location();
        return register.register(name, () -> {
            RecipeTypeEntry.Builder builder = new RecipeTypeEntry.Builder();
            builder.setRegistryName(id);
            consumer.accept(id, builder);
            return builder.createRecipeTypeEntry();
        });
    }

    public static DeferredRegister<EquipmentTypeEntry> equipmentTypes(String modid) {
        return DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"equipmenttypes"), (String)modid);
    }

    private DeferredRegisterHelper() {
    }
}

