/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building.module;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModuleView;
import steve_gall.minecolonies_tweaks.core.common.network.message.AssignIdListMessage;

public abstract class AbstractIdListModuleView
extends AbstractBuildingModuleView
implements IIdListModuleView {
    private String listId = "";
    private final Set<ResourceLocation> ids = new HashSet<ResourceLocation>();

    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.listId = buf.readUtf();
        this.ids.clear();
        this.ids.addAll(buf.readCollection(HashSet::new, FriendlyByteBuf::readResourceLocation));
    }

    @Override
    public boolean addIds(@NotNull Collection<ResourceLocation> ids) {
        PacketDistributor.sendToServer((CustomPacketPayload)new AssignIdListMessage(this, AssignIdListMessage.Function.ADD, ids), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return this.ids.addAll(ids);
    }

    @Override
    public boolean containsId(@NotNull ResourceLocation id) {
        return this.ids.contains(id);
    }

    @Override
    public boolean removeIds(@NotNull Collection<ResourceLocation> ids) {
        PacketDistributor.sendToServer((CustomPacketPayload)new AssignIdListMessage(this, AssignIdListMessage.Function.REMOVE, ids), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return this.ids.removeAll(ids);
    }

    @Override
    public void clearIds() {
        PacketDistributor.sendToServer((CustomPacketPayload)new AssignIdListMessage(this, AssignIdListMessage.Function.CLEAR, Collections.emptyList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.ids.clear();
    }

    @Override
    @NotNull
    public String getListId() {
        return this.listId;
    }
}

