/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building.module;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public abstract class AbstractIdListModule
extends AbstractBuildingModule
implements IPersistentModule,
IIdListModule {
    public static final String TAG_IDS = MineColoniesTweaks.rl("ids").toString();
    @NotNull
    private final String listId;
    @NotNull
    private final Set<ResourceLocation> ids;

    public AbstractIdListModule(@NotNull String listId) {
        this.listId = listId;
        this.ids = new HashSet<ResourceLocation>();
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.ids.clear();
        ListTag idsTag = compound.getList(TAG_IDS, 8);
        for (int i = 0; i < idsTag.size(); ++i) {
            this.ids.add(ResourceLocation.parse((String)idsTag.getString(i)));
        }
    }

    public void serializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        ListTag idsTag = new ListTag();
        compound.put(TAG_IDS, (Tag)idsTag);
        for (ResourceLocation id : this.ids) {
            idsTag.add((Object)StringTag.valueOf((String)id.toString()));
        }
    }

    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeUtf(this.listId);
        buf.writeCollection(this.ids, FriendlyByteBuf::writeResourceLocation);
    }

    protected void onIdAdded(@NotNull ResourceLocation id) {
    }

    protected void onIdRemoved(@NotNull ResourceLocation id) {
    }

    protected void onIdsCleared() {
    }

    protected void onIdsChanged() {
    }

    @Override
    public boolean addId(@NotNull ResourceLocation id) {
        boolean added = this.ids.add(id);
        if (added) {
            this.onIdAdded(id);
            this.onIdsChanged();
            this.markDirty();
        }
        return added;
    }

    @Override
    public boolean addIds(@NotNull Collection<ResourceLocation> ids) {
        boolean anyAdded = false;
        for (ResourceLocation id : ids) {
            if (!this.ids.add(id)) continue;
            anyAdded = true;
            this.onIdAdded(id);
        }
        if (anyAdded) {
            this.onIdsChanged();
            this.markDirty();
        }
        return anyAdded;
    }

    @Override
    public boolean containsId(@NotNull ResourceLocation id) {
        return this.ids.contains(id);
    }

    @Override
    public boolean removeId(@NotNull ResourceLocation id) {
        boolean removed = this.ids.remove(id);
        if (removed) {
            this.onIdRemoved(id);
            this.onIdsChanged();
            this.markDirty();
        }
        return removed;
    }

    @Override
    public boolean removeIds(@NotNull Collection<ResourceLocation> ids) {
        boolean anyRemoved = false;
        for (ResourceLocation id : ids) {
            if (!this.ids.remove(id)) continue;
            anyRemoved = true;
            this.onIdRemoved(id);
        }
        if (anyRemoved) {
            this.onIdsChanged();
            this.markDirty();
        }
        return false;
    }

    @Override
    public void clearIds() {
        this.ids.clear();
        this.onIdsCleared();
        this.onIdsChanged();
        this.markDirty();
    }

    @NotNull
    public Set<ResourceLocation> getIds() {
        return new HashSet<ResourceLocation>(this.ids);
    }

    @Override
    @NotNull
    public String getListId() {
        return this.listId;
    }
}

