/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.BlockPosUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingPos {
    public static final String TAG_DIMENSION_ID = "dimensionId";
    public static final String TAG_COLONY_ID = "colonyId";
    public static final String TAG_BUILDING_ID = "buildingId";
    public static final Codec<BuildingPos> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Level.RESOURCE_KEY_CODEC.fieldOf(TAG_DIMENSION_ID).forGetter(BuildingPos::getDimensionId), (App)Codec.INT.fieldOf(TAG_COLONY_ID).forGetter(BuildingPos::getColonyId), (App)BlockPos.CODEC.fieldOf(TAG_BUILDING_ID).forGetter(BuildingPos::getBuildingId)).apply((Applicative)builder, BuildingPos::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BuildingPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), BuildingPos::getDimensionId, (StreamCodec)ByteBufCodecs.VAR_INT, BuildingPos::getColonyId, (StreamCodec)BlockPos.STREAM_CODEC, BuildingPos::getBuildingId, BuildingPos::new);
    @NotNull
    private final ResourceKey<Level> dimensionId;
    private final int colonyId;
    @NotNull
    private final BlockPos buildingId;

    public BuildingPos(@NotNull CompoundTag tag) {
        this.dimensionId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString(TAG_DIMENSION_ID)));
        this.colonyId = tag.getInt(TAG_COLONY_ID);
        this.buildingId = BlockPosUtil.read((CompoundTag)tag, (String)TAG_BUILDING_ID);
    }

    public BuildingPos(@NotNull FriendlyByteBuf buffer) {
        this.dimensionId = buffer.readResourceKey(Registries.DIMENSION);
        this.colonyId = buffer.readInt();
        this.buildingId = buffer.readBlockPos();
    }

    public BuildingPos(@NotNull ColonyId colonyId, @NotNull BuildingId buildingId) {
        this.dimensionId = colonyId.dimension();
        this.colonyId = colonyId.id();
        this.buildingId = buildingId.id();
    }

    public BuildingPos(@NotNull ResourceKey<Level> dimensionId, int colonyId, @NotNull BlockPos buildingId) {
        this.dimensionId = dimensionId;
        this.colonyId = colonyId;
        this.buildingId = buildingId;
    }

    public BuildingPos(@NotNull IColony colony, @NotNull BlockPos buildingId) {
        this((ResourceKey<Level>)colony.getDimension(), colony.getID(), buildingId);
    }

    public BuildingPos(@NotNull IBuilding building) {
        this(building.getColony(), building.getID());
    }

    public BuildingPos(@NotNull IBuildingView buildingView) {
        this((IColony)buildingView.getColony(), buildingView.getID());
    }

    public int hashCode() {
        return Objects.hash(this.dimensionId, this.colonyId, this.buildingId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BuildingPos) {
            BuildingPos other = (BuildingPos)obj;
            return this.dimensionId == other.dimensionId && this.colonyId == other.colonyId && this.buildingId.equals((Object)other.buildingId);
        }
        return false;
    }

    @Nullable
    public IBuilding getBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimensionId);
        if (colony == null) {
            return null;
        }
        return colony.getBuildingManager().getBuilding(this.buildingId);
    }

    @Nullable
    public IBuildingView getBuildingView() {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimensionId);
        if (colony == null) {
            return null;
        }
        return colony.getBuilding(this.buildingId);
    }

    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString(TAG_DIMENSION_ID, this.dimensionId.location().toString());
        tag.putInt(TAG_COLONY_ID, this.colonyId);
        BlockPosUtil.write((CompoundTag)tag, (String)TAG_BUILDING_ID, (BlockPos)this.buildingId);
        return tag;
    }

    public void serializeBuffer(@NotNull FriendlyByteBuf buffer) {
        buffer.writeResourceKey(this.dimensionId);
        buffer.writeInt(this.colonyId);
        buffer.writeBlockPos(this.buildingId);
    }

    @NotNull
    public ResourceKey<Level> getDimensionId() {
        return this.dimensionId;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    @NotNull
    public BlockPos getBuildingId() {
        return this.buildingId;
    }

    public int getX() {
        return this.getBuildingId().getX();
    }

    public int getY() {
        return this.getBuildingId().getY();
    }

    public int getZ() {
        return this.getBuildingId().getZ();
    }
}

