/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.undergarden;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class UnderbeanFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return UGBlocks.UNDERBEAN_BUSH.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)UGItems.UNDERBEANS.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)UGItems.UNDERBEANS.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == UGBlocks.UNDERBEAN_BUSH.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)UnderbeanBushBlock.AGE) > 1;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)UnderbeanBushBlock.AGE) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            Integer i = (Integer)state.getValue((Property)UnderbeanBushBlock.AGE);
            boolean flag = i == 3;
            int j = 1 + level.random.nextInt(2);
            BlockState newState = (BlockState)state.setValue((Property)UnderbeanBushBlock.AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(context.getPosition(), newState, 2);
            return Collections.singletonList(new ItemStack((ItemLike)UGItems.UNDERBEANS.get(), j + (flag ? 1 : 0)));
        }
        return Collections.emptyList();
    }
}

