/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.neapolitan;

import com.teamabnormals.neapolitan.common.block.StrawberryBushBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

public class StrawBerryCrop
extends CustomizedCrop {
    @Override
    public boolean isSeed(@NotNull PlantSeedContext context) {
        return context.getSeed().is((Item)NeapolitanItems.STRAWBERRY_PIPS.get());
    }

    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        return context.getState().is((Block)NeapolitanBlocks.STRAWBERRY_BUSH.get());
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getHarvestPosition;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvest;
    }

    @Nullable
    private BlockPos getHarvestPosition(@NotNull PlantBlockContext context) {
        StrawberryBushBlock block;
        BlockState state = context.getState();
        Block block2 = state.getBlock();
        if (block2 instanceof StrawberryBushBlock && (block = (StrawberryBushBlock)block2).isMaxAge(state)) {
            return context.getPosition();
        }
        return null;
    }

    private List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            int count = 1 + level.random.nextInt(2);
            Item item = (Boolean)state.getValue((Property)StrawberryBushBlock.WHITE) != false ? (Item)NeapolitanItems.WHITE_STRAWBERRIES.get() : (Item)NeapolitanItems.STRAWBERRIES.get();
            level.setBlock(context.getPosition(), (BlockState)((BlockState)state.setValue((Property)StrawberryBushBlock.AGE, (Comparable)Integer.valueOf(1))).setValue((Property)StrawberryBushBlock.WHITE, (Comparable)Boolean.valueOf(false)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)item, count));
        }
        return Collections.emptyList();
    }
}

