/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.neapolitan;

import com.teamabnormals.neapolitan.common.block.MintBlock;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class MintLeavesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return NeapolitanItems.MINT_LEAVES.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)NeapolitanBlocks.MINT.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)NeapolitanItems.MINT_LEAVES.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == NeapolitanBlocks.MINT.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        MintBlock block;
        BlockState state = context.getState();
        Block block2 = state.getBlock();
        return block2 instanceof MintBlock && (block = (MintBlock)block2).isMaxAge(state);
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        Integer sprouts;
        BlockState state = context.getState();
        Integer drops = sprouts = (Integer)state.getValue((Property)MintBlock.SPROUTS);
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState newState = (BlockState)state.setValue((Property)MintBlock.AGE, (Comparable)Integer.valueOf(1));
            int maxSprouts = 4;
            if (sprouts < maxSprouts) {
                int sproutsWithDrops = sprouts + drops;
                newState = (BlockState)newState.setValue((Property)MintBlock.SPROUTS, (Comparable)Integer.valueOf(Math.min(maxSprouts, sproutsWithDrops)));
                drops = sproutsWithDrops - (Integer)newState.getValue((Property)MintBlock.SPROUTS);
            }
            level.setBlock(context.getPosition(), newState, 2);
        }
        if (drops > 0) {
            return Collections.singletonList(new ItemStack((ItemLike)NeapolitanItems.MINT_LEAVES.get(), drops.intValue()));
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.CROP_BREAK;
    }
}

