/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ie;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;

public class DefaultBullet
implements BulletHandler.IBullet<Data> {
    public static final BulletHandler.CodecsAndDefault<Data> DATA_CODEC = new BulletHandler.CodecsAndDefault(new DualCodec(Data.CODEC, Data.STREAM_CODEC), (Object)new Data(0.0));
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("ie_default");
    public static final DefaultBullet INSTANCE = new DefaultBullet();
    private final ResourceLocation[] textures = new ResourceLocation[]{ResourceLocation.parse((String)"immersiveengineering:item/bullet_casull")};

    private DefaultBullet() {
    }

    public boolean isProperCartridge() {
        return false;
    }

    public void onHitTarget(Level level, HitResult rtr, @Nullable UUID shooterUUID, Entity projectile, boolean headshot, Data data) {
        if (level.isClientSide()) {
            return;
        }
        Entity hitEntity = null;
        if (rtr instanceof EntityHitResult) {
            EntityHitResult target = (EntityHitResult)rtr;
            hitEntity = target.getEntity();
            if (hitEntity == null) {
                return;
            }
        } else {
            return;
        }
        Entity shooter = null;
        if (shooterUUID != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            shooter = serverLevel.getEntity(shooterUUID);
        }
        double damage = data.damage();
        if (headshot) {
            damage *= ((Double)MineColoniesCompatibilityConfigServer.INSTANCE.modules.IE.job.gunnerRevolver.defaultBulletHeadshotMultiplier.get()).doubleValue();
        }
        hitEntity.hurt(IEDamageSources.causeHomingDamage((RevolvershotEntity)((RevolvershotEntity)projectile), (Entity)shooter), (float)damage);
    }

    public ItemStack getCasing(ItemStack stack) {
        return ItemStack.EMPTY;
    }

    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    public BulletHandler.CodecsAndDefault<Data> getCodec() {
        return DATA_CODEC;
    }

    public record Data(double damage) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("damage").forGetter(Data::damage)).apply((Applicative)builder, Data::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Data::damage, Data::new);
    }
}

