/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ie;

import blusunrize.immersiveengineering.common.items.BulletItem;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class Bullet
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("ie_bullet");
    public static final Component SHORT_DISPLAY_STRING = Component.translatable((String)MineColoniesCompatibility.tl("ie_bullet"));
    public static final Component LONG_DISPLAY_STRING = Component.translatable((String)MineColoniesCompatibility.tl("ie_bullet.desc"));
    private static List<ItemStack> BULLET_EXAMPLES = null;
    private final int minCount;

    public Bullet(int minCount) {
        this.minCount = minCount;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static Bullet deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        int minCount = tag.getInt("minCount");
        return new Bullet(minCount);
    }

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, Bullet request) {
        tag.putInt("minCount", request.minCount);
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (BULLET_EXAMPLES == null) {
            BULLET_EXAMPLES = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(this::matches).toList();
        }
        return BULLET_EXAMPLES;
    }

    public Bullet copyWithCount(int newCount) {
        return new Bullet(this.minCount);
    }

    public int getCount() {
        return 64;
    }

    public int getMinimumCount() {
        return this.minCount;
    }

    public boolean matches(@NotNull ItemStack stack) {
        return stack.getItem() instanceof BulletItem;
    }
}

