/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class TomatoCrop
extends CustomizedCrop {
    public static final int MAX_VINE_HEIGHT = 3;

    @Override
    public boolean isSeed(@NotNull PlantSeedContext context) {
        return context.getSeed().getItem() == ModItems.TOMATO_SEEDS.get();
    }

    @Override
    public boolean isCrop(@NotNull PlantBlockContext context) {
        Block block = context.getState().getBlock();
        return block == ModBlocks.BUDDING_TOMATO_CROP.get() || block == ModBlocks.TOMATO_CROP.get();
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return this::getPositionIfAnyVineHarvestable;
    }

    @Override
    @Nullable
    public CustomizedCrop.SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return this::harvestVines;
    }

    private BlockPos getPositionIfAnyVineHarvestable(@NotNull PlantBlockContext context) {
        BlockPos vinePosition;
        BlockState state;
        Block block;
        LevelReader level = context.getLevel();
        BlockPos basePosition = context.getPosition();
        for (int i = 0; i < 3 && (block = (state = level.getBlockState(vinePosition = basePosition.above(i))).getBlock()) instanceof TomatoVineBlock; ++i) {
            TomatoVineBlock vine = (TomatoVineBlock)block;
            if (!vine.isMaxAge(state)) continue;
            return basePosition;
        }
        return null;
    }

    private List<ItemStack> harvestVines(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            BlockPos vinePosition;
            BlockState vineState;
            Block block;
            ServerLevel level = (ServerLevel)levelReader;
            BlockPos basePosition = context.getPosition();
            RandomSource random = level.random;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < 3 && (block = (vineState = level.getBlockState(vinePosition = basePosition.above(i))).getBlock()) instanceof TomatoVineBlock; ++i) {
                TomatoVineBlock vine = (TomatoVineBlock)block;
                if (!vine.isMaxAge(vineState)) continue;
                list.add(new ItemStack((ItemLike)ModItems.TOMATO.get(), 1 + random.nextInt(2)));
                if ((double)random.nextFloat() < 0.05) {
                    list.add(new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get()));
                }
                BlockState vineNewState = (BlockState)vineState.setValue((Property)vine.getAgeProperty(), (Comparable)Integer.valueOf(0));
                level.setBlock(vinePosition, vineNewState, 2);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

