/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.menu;

import com.lance5057.butchercraft.ButchercraftRecipes;
import com.lance5057.butchercraft.workstations.grinder.GrinderContainer;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.crafting.GrinderGenericRecipe;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.init.ModuleMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class GrinderTeachMenu
extends TeachRecipeMenu<RecipeHolder<GrinderRecipe>, GrinderContainer> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int INGREDIENT_X = 26;
    public static final int INGREDIENT_Y = 35;
    public static final int ATTACHMENT_X = 44;
    public static final int ATTACHMENT_Y = 35;
    public static final int CASING_X = 62;
    public static final int CASING_Y = 35;
    public static final int RESULT_X = 116;
    public static final int RESULT_Y = 35;

    public GrinderTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.GRINDER_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public GrinderTeachMenu(int windowId, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.GRINDER_TEACH.get(), windowId, inventory, (FriendlyByteBuf)buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 3);
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 0, 26, 35)));
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 1, 44, 35)));
        this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, 2, 62, 35)));
        this.resultContainer = new TeachContainer(this, 1);
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 0, 116, 35)));
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<GrinderRecipe>, GrinderContainer> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<GrinderRecipe, GrinderContainer>(this, this.inventory.player.level()){

            @Override
            public RecipeType<GrinderRecipe> getRecipeType() {
                return (RecipeType)ButchercraftRecipes.GRINDER.get();
            }

            @Override
            @NotNull
            public GrinderContainer getInput(@NotNull Container container, @Nullable RecipeHolder<GrinderRecipe> recipe) {
                return new GrinderContainer(container.getItem(0), container.getItem(1));
            }

            @Override
            protected boolean test(RecipeHolder<GrinderRecipe> recipeHolder, Container container, ServerPlayer player) {
                if (!super.test(recipeHolder, container, player)) {
                    return false;
                }
                ItemStack attachment = container.getItem(1);
                ItemStack casing = container.getItem(2);
                return GrinderGenericRecipe.casing(attachment).test(casing);
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull HolderLookup.Provider provider, @NotNull RecipeHolder<GrinderRecipe> recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        List input = NBTUtils2.deserializeList(payload, "input", ItemSerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        this.inputContainer.setItem(0, (ItemStack)input.get(0));
        this.inputContainer.setItem(1, (ItemStack)input.get(1));
        this.inputContainer.setItem(2, (ItemStack)input.get(2));
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, GrinderContainer input) {
        this.resultContainer.setItem(0, this.recipe != null ? ((GrinderRecipe)((RecipeHolder)this.recipe).value()).assemble(input, provider) : ItemStack.EMPTY);
    }
}

