/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.crafting;

import com.lance5057.butchercraft.ButchercraftBlocks;
import com.lance5057.butchercraft.ButchercraftItems;
import com.lance5057.butchercraft.tags.ButchercraftItemTags;
import com.lance5057.butchercraft.workstations.grinder.GrinderRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleGenericRecipe;

public class GrinderGenericRecipe
extends SimpleGenericRecipe {
    private final List<ItemStack> attachment;

    public GrinderGenericRecipe(RecipeHolder<GrinderRecipe> recipe, RegistryAccess registryAccess) {
        this(recipe.id(), GrinderGenericRecipe.ingredientsWithCasing((GrinderRecipe)recipe.value()), ((GrinderRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess), ((GrinderRecipe)recipe.value()).attachment());
    }

    public GrinderGenericRecipe(ResourceLocation recipeId, List<List<ItemStack>> ingredients, ItemStack output, Ingredient attachment) {
        super(recipeId, ingredients, output);
        this.attachment = Arrays.asList(attachment.getItems());
    }

    public static List<List<ItemStack>> ingredientsWithCasing(GrinderRecipe recipe) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.add(GrinderGenericRecipe.ingredients(recipe.ingredient(), recipe.count()));
        List<ItemStack> casing = GrinderGenericRecipe.casing(recipe.attachment());
        if (casing.size() > 0) {
            list.add(casing);
        }
        return list;
    }

    public static List<ItemStack> ingredients(Ingredient ingredient, int count) {
        return Arrays.stream(ingredient.getItems()).map(item -> {
            ItemStack copy = item.copy();
            copy.setCount(count);
            return copy;
        }).toList();
    }

    public static List<ItemStack> casing(Ingredient attachment) {
        return Arrays.stream(attachment.getItems()).map(GrinderGenericRecipe::casing).flatMap(i -> Arrays.stream(i.getItems())).toList();
    }

    public static Ingredient casing(ItemStack attachment) {
        if (attachment.is((Item)ButchercraftItems.EXTRUDER_TIP.get())) {
            return Ingredient.of((TagKey)ButchercraftItemTags.SAUSAGE_CASING);
        }
        return Ingredient.EMPTY;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        list.addAll(super.getInputs());
        if (this.attachment.size() > 0) {
            list.add(this.attachment);
        }
        return list;
    }

    @Override
    @NotNull
    public Block getIntermediate() {
        return (Block)ButchercraftBlocks.GRINDER.get();
    }

    public List<ItemStack> getAttachment() {
        return this.attachment;
    }
}

