/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.butchercraft.butcherable;

import com.lance5057.butchercraft.ButchercraftBlocks;
import com.lance5057.butchercraft.workstations.bases.recipes.AnimatedRecipeItemUse;
import com.lance5057.butchercraft.workstations.hook.HookRecipe;
import com.lance5057.butchercraft.workstations.hook.MeatHookBlock;
import com.lance5057.butchercraft.workstations.hook.MeatHookBlockEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherBlockContext;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherCitizenContext;
import steve_gall.minecolonies_compatibility.api.common.crafting.ToolOrIngredientStack;
import steve_gall.minecolonies_compatibility.core.common.colony.ColonyHelper;
import steve_gall.minecolonies_compatibility.core.common.inventory.InventoryHelper;
import steve_gall.minecolonies_compatibility.core.common.network.message.BlockEntityRequestModelDataUpdateMessage;
import steve_gall.minecolonies_compatibility.core.common.util.InteractionMessageHelper;
import steve_gall.minecolonies_compatibility.mixin.common.butchercraft.MeatHookBlockEntityAccessor;
import steve_gall.minecolonies_compatibility.module.common.butchercraft.butcherable.AbstractButcherable;

public class HookButcherable
extends AbstractButcherable {
    private final ResourceLocation id;
    private final HookRecipe recipe;
    private final List<ItemStack> itemIcons;
    private final List<BlockState> tableIcons;
    private final List<ToolOrIngredientStack> toolIcons;

    public HookButcherable(RecipeHolder<HookRecipe> recipe) {
        this.id = recipe.id();
        this.recipe = (HookRecipe)recipe.value();
        this.itemIcons = Arrays.asList(this.recipe.carcass().getItems());
        this.tableIcons = Collections.singletonList(((MeatHookBlock)ButchercraftBlocks.MEAT_HOOK.get()).defaultBlockState());
        this.toolIcons = this.getToolIcons((List<AnimatedRecipeItemUse>)this.recipe.tools());
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    @NotNull
    public List<Ingredient> getOutputIcons() {
        return this.recipe.jei();
    }

    @Override
    @NotNull
    public List<BlockState> getTableIcons() {
        return this.tableIcons;
    }

    @Override
    @NotNull
    public List<ToolOrIngredientStack> getToolsForIcon() {
        return this.toolIcons;
    }

    @Override
    public boolean testItem(@NotNull ItemStack item) {
        return this.recipe.carcass().test(item);
    }

    @Override
    public boolean isTableBlock(@NotNull ButcherBlockContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getPosition());
        if (blockEntity instanceof MeatHookBlockEntity) {
            MeatHookBlockEntity blockEntity2 = (MeatHookBlockEntity)blockEntity;
            return blockEntity2.getInsertedItem().isEmpty();
        }
        return false;
    }

    @Override
    public void doButcherTable(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen, @NotNull InteractionHand itemHand) {
        super.doButcherTable(context, citizen, itemHand);
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getPosition());
        if (blockEntity instanceof MeatHookBlockEntity) {
            MeatHookBlockEntity blockEntity2 = (MeatHookBlockEntity)blockEntity;
            blockEntity2.insertItem(citizen.getWorker().getItemInHand(itemHand));
            PacketDistributor.sendToPlayersTrackingEntity((Entity)citizen.getWorker(), (CustomPacketPayload)new BlockEntityRequestModelDataUpdateMessage((BlockEntity)blockEntity2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    @NotNull
    public ToolOrIngredientStack getBlockTool(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getPosition());
        if (blockEntity instanceof MeatHookBlockEntity) {
            MeatHookBlockEntity blockEntity2 = (MeatHookBlockEntity)blockEntity;
            ToolOrIngredientStack tool = blockEntity2.getCurrentTool().map(this::getTool).orElse(ToolOrIngredientStack.EMPTY);
            return this.trySkip(tool::testType, citizen.getAI()) ? ToolOrIngredientStack.EMPTY : tool;
        }
        return ToolOrIngredientStack.EMPTY;
    }

    @Override
    public boolean isButcheringBlock(@NotNull ButcherBlockContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getPosition());
        if (blockEntity instanceof MeatHookBlockEntity) {
            MeatHookBlockEntity blockEntity2 = (MeatHookBlockEntity)blockEntity;
            return this.recipe.carcass().test(blockEntity2.getInsertedItem());
        }
        return false;
    }

    @Override
    public void doButcherBlock(@NotNull ButcherBlockContext context, @NotNull ButcherCitizenContext citizen) {
        super.doButcherBlock(context, citizen);
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getPosition());
        if (blockEntity instanceof MeatHookBlockEntity) {
            MeatHookBlockEntity blockEntity2 = (MeatHookBlockEntity)blockEntity;
            AbstractEntityCitizen worker = citizen.getWorker();
            FakePlayer player = ColonyHelper.getFakeOwner(worker.getCitizenData().getColony());
            if (player == null) {
                return;
            }
            if (blockEntity2.maxProgress == 0) {
                ((MeatHookBlockEntityAccessor)blockEntity2).invokeSetupStage(this.recipe, 0);
            }
            int stage = blockEntity2.stage;
            NonNullList tools = this.recipe.tools();
            AnimatedRecipeItemUse itemUse = (AnimatedRecipeItemUse)tools.get(stage);
            if (this.trySkip(arg_0 -> ((Ingredient)itemUse.tool()).test(arg_0), citizen.getAI())) {
                if (stage + 1 < tools.size()) {
                    ((MeatHookBlockEntityAccessor)blockEntity2).invokeSetupStage(this.recipe, stage + 1);
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)worker, (CustomPacketPayload)new BlockEntityRequestModelDataUpdateMessage((BlockEntity)blockEntity2), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    blockEntity2.finishRecipe();
                }
                blockEntity2.updateInventory();
                return;
            }
            int maxProgress = blockEntity2.maxProgress;
            int maxToolCount = blockEntity2.toolCount * maxProgress;
            InteractionHand toolHand = InteractionHand.MAIN_HAND;
            ItemStack tool = worker.getItemInHand(toolHand).copy();
            tool.setCount(maxToolCount);
            blockEntity2.progress = maxProgress;
            blockEntity2.butcher((Player)player, tool);
            if (tool.isDamageableItem()) {
                CitizenItemUtils.damageItemInHand((AbstractEntityCitizen)worker, (InteractionHand)toolHand, (int)maxProgress);
            } else {
                InventoryCitizen inventory = worker.getInventoryCitizen();
                ToolOrIngredientStack toolType = this.getTool(itemUse);
                InventoryHelper.removeStacksFromItemHandler((IItemHandler)inventory, maxToolCount, toolType::testType);
            }
        }
    }

    @Override
    @NotNull
    public Component getTableNotFoundMessage() {
        return InteractionMessageHelper.getWorkingBlockNotFound((Block)ButchercraftBlocks.MEAT_HOOK.get());
    }

    @NotNull
    public HookRecipe getRecipe() {
        return this.recipe;
    }
}

