/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.atmospheric;

import com.teamabnormals.atmospheric.common.block.BarrelCactusBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class BarrelCactusFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AtmosphericItems.BARREL_CACTUS.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericBlocks.BARREL_CACTUS.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Collections.singletonList(new ItemStack((ItemLike)AtmosphericItems.BARREL_CACTUS.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == AtmosphericBlocks.BARREL_CACTUS.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)BarrelCactusBlock.AGE) > 0;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)BarrelCactusBlock.AGE) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState state = context.getState();
            Integer count = (Integer)state.getValue((Property)BarrelCactusBlock.AGE);
            level.setBlock(context.getPosition(), (BlockState)state.setValue((Property)BarrelCactusBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)AtmosphericItems.BARREL_CACTUS.get(), count.intValue()));
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundType.WOOL.getBreakSound();
    }
}

