/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ars_nouveau;

import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class SourceBerryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return BlockRegistry.SOURCEBERRY_BUSH.registryObject.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH.asItem()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == BlockRegistry.SOURCEBERRY_BUSH.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)SourceBerryBush.AGE) > 1;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)SourceBerryBush.AGE) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            Integer age = (Integer)state.getValue((Property)SourceBerryBush.AGE);
            int count = 1 + level.random.nextInt(2) + (age == 3 ? 1 : 0);
            level.setBlock(context.getPosition(), (BlockState)state.setValue((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(1)), 2);
            return Collections.singletonList(new ItemStack((ItemLike)BlockRegistry.SOURCEBERRY_BUSH, count));
        }
        return Collections.emptyList();
    }
}

