/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.aether;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.item.AetherItems;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class BlueBerryFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return AetherBlocks.BERRY_BUSH.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)AetherBlocks.BERRY_BUSH_STEM.get()), new ItemStack((ItemLike)AetherBlocks.BERRY_BUSH.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)AetherItems.BLUE_BERRY.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        Block block = context.getState().getBlock();
        return block == AetherBlocks.BERRY_BUSH_STEM.get() || block == AetherBlocks.BERRY_BUSH.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        Block block = context.getState().getBlock();
        return block == AetherBlocks.BERRY_BUSH.get();
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState state = context.getState();
            BooleanProperty property = AetherBlockStateProperties.DOUBLE_DROPS;
            BlockState newState = (BlockState)((Block)AetherBlocks.BERRY_BUSH_STEM.get()).defaultBlockState().setValue((Property)property, (Comparable)((Boolean)state.getValue((Property)property)));
            level.setBlock(context.getPosition(), newState, 3);
        }
        return context.getDrops(harvester);
    }
}

